% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcatfish_glossary.R
\name{rcatfish_glossary}
\alias{rcatfish_glossary}
\title{Access the Eschmeyer's Catalog of Fishes Glossary}
\usage{
rcatfish_glossary()
}
\value{
A dataframe with three columns. Some terms have sub-terms (e.g. synonym will have definitions for junior, objective, and subjective in addition to defining synonym itself). The first column represents the name of the main term, the second column represents the name of sub-terms, and the final column provides the definition for these terms.
}
\description{
This function is used to access the Eschmeyer's Catalog of Fishes Glossary.
}
\details{
This function displays the Glossary tab of Eschmeyer's Catalog of Fishes. The glossary contains definitions for various terms that are important to the discussion of taxonomy and are mentioned throughout the database.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
\donttest{
# Obtain the Eschmeyer's Catalog of Fishes Glossary
myGlossary <- rcatfish_glossary()
}
\dontshow{\}) # examplesIf}
}
\references{
van der Laan, R., Fricke, R. & Fong, J. (Year Accessed). Eschmeyer's Catalog of Fishes: Glossary. https://www.calacademy.org/scientists/catalog-of-fishes-glossary/.
}
\author{
Samuel R. Borstein
}
