% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_brand.R
\name{get_brand_private_github}
\alias{get_brand_private_github}
\title{Download the latest branding file from a private GitHub repository}
\usage{
get_brand_private_github(
  remote_file = NULL,
  local_file = NULL,
  auth_token = NULL,
  config_file = "rbranding_config.yml",
  run_interactive = TRUE,
  backup = FALSE,
  backup_folder = "."
)
}
\arguments{
\item{remote_file}{Optional URL. Points to the remote brand file.
If \code{NULL}, the value in the configuration file will be used.}

\item{local_file}{Optional string. Path to the local branding file.
If \code{NULL}, the value in the configuration file will be used.}

\item{auth_token}{Optional authentication token for accessing the private
GitHub repository. If \code{NULL}, the function will attempt to retrieve the token
from the \code{GITHUB_TOKEN} environment variable or the git credential store.}

\item{config_file}{Path to the configuration file.
Default is \code{rbranding_config.yml}.}

\item{run_interactive}{Logical indicating whether to run interactively.
Defaults to TRUE.}

\item{backup}{Logical indicating whether to create a backup of the local file
if it is different from the remote file. Ignored if run interactively.
Defaults to FALSE.}

\item{backup_folder}{Folder where the backup file should be saved, if needed.
Defaults to current working directory.}
}
\value{
NULL. Called for its side effects: updating \verb{_brand.yml} and
possibly creating \code{bak_brand.yml}
}
\description{
\code{get_brand_private_github} downloads the latest \verb{_brand.yml} file from the
remote URL specified in \code{rbranding_config.yml} or provided as function
arguments.
The remote file is assumed to be in a private GitHub repository and requires
authentication.
If the local \verb{_brand.yml} file does not exist, it will be created.
If the local file is different from the remote file, the function will save
the contents to \code{bak_brand.yml} (as backup) and overwrite the local file with
the contents of the remote file.
When the function is run interactively (e.g., in RStudio console), the user
is instead prompted to choose whether to overwrite the file and whether or
not to create the backup.
}
\examples{
# Interactive example
if (interactive()) {
  tmpdir <- file.path(tempdir(), "brand_files")

  # Initialize config and local brand file
  brand_init(install_path = tmpdir)

  # Update local brand file if needed
  get_brand_private_github(
    config_file = file.path(tmpdir, "rbranding_config.yml")
  )

  # Cleanup
  unlink(tmpdir, recursive = TRUE)
}

\dontrun{
  # Example not run because it requires a GitHub
  # personal access token with repo access

  tmpdir <- file.path(tempdir(), "brand_files")
  brand_init(install_path = tmpdir)

  get_brand_private_github(
   config_file = file.path(tmpdir, "rbranding_config.yml"),
   auth_token = "your_github_token_here",
   run_interactive = FALSE,
   backup = TRUE,
   backup_folder = tmpdir
  )

  # Cleanup
  unlink(tmpdir, recursive = TRUE)
}
}
