% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rblimp.R, R/rblimp_fcs.R, R/rblimp_syntax.R
\name{rblimp}
\alias{rblimp}
\alias{rblimp_fcs}
\alias{rblimp_syntax}
\title{Wrapper functions to provide Blimp functions in R}
\usage{
rblimp(
  model,
  data,
  burn = 10000,
  iter = 10000,
  seed,
  thin,
  nimps,
  latent,
  randomeffect,
  parameters,
  clusterid,
  timeid,
  weight,
  ordinal,
  nominal,
  count,
  center,
  chains,
  simple,
  waldtest,
  options,
  transform,
  dropout,
  filter,
  fixed,
  output,
  tmpfolder,
  add_save = TRUE,
  print_output = TRUE,
  nopowershell = FALSE
)

rblimp_fcs(
  variables,
  data,
  burn = 10000,
  iter = 10000,
  seed,
  thin,
  nimps,
  clusterid,
  ordinal,
  nominal,
  chains,
  options,
  transform,
  fixed,
  output,
  tmpfolder,
  add_save = TRUE,
  print_output = TRUE,
  nopowershell = FALSE
)

rblimp_syntax(
  model,
  data,
  burn,
  iter,
  seed,
  thin,
  nimps,
  latent,
  randomeffect,
  parameters,
  clusterid,
  timeid,
  weight,
  ordinal,
  nominal,
  count,
  transform,
  dropout,
  filter,
  fixed,
  center,
  chains,
  simple,
  waldtest,
  options,
  save,
  output
)
}
\arguments{
\item{model}{a character string or vector/list of character strings. Specifies Blimp's MODEL command. See details.}

\item{data}{a \code{\link{data.frame}} or a \code{\link{SIMULATE}} object.
If a data.frame, the data set used by Blimp.
If a SIMULATE object (created with \code{\link[=SIMULATE]{SIMULATE()}}), Blimp will generate simulated data instead of using existing data}

\item{burn}{an integer. The number of burn-in iterations to be run}

\item{iter}{an integer. The number of post burn-in iterations to be run}

\item{seed}{a positive integer. The seeding value for Blimp's pseudo random number generator}

\item{thin}{an integer. The thinning interval for imputations only.}

\item{nimps}{an integer. The number of imputations to save.}

\item{latent}{a character string, formula, or vector/list of character strings. Specifies Blimp's LATENT command. See details.}

\item{randomeffect}{a character string or vector/list of character strings. Specifies Blimp's RANDOMEFFECTS command.}

\item{parameters}{a character string or vector/list of character strings. Specifies Blimp's MODEL command. See details.}

\item{clusterid}{a character string, formula, or vector/list of character strings. Specifies Blimp's CLUSTERID command. See details.}

\item{timeid}{a character string, formula, or vector/list of character strings. Specifies Blimp's TIMEID command. See details.}

\item{weight}{a character string, formula, or vector/list of character strings. Specifies Blimp's WEIGHT command. See details.}

\item{ordinal}{a character string, formula, or vector/list of character strings. Specifies Blimp's ORDINAL command. See details.}

\item{nominal}{a character string, formula, or vector/list of character strings. Specifies Blimp's NOMINAL command. See details.}

\item{count}{a character string, formula, or vector/list of character strings. Specifies Blimp's COUNT command. See details.}

\item{center}{a character string, formula, or vector/list of character strings. Specifies Blimp's CENTER command. See details.}

\item{chains}{an integer, character string, or vector/list of character strings. Specifies Blimp's CHAINS command.}

\item{simple}{a character string or vector/list of character strings. Specifies Blimp's SIMPLE command. See details.}

\item{waldtest}{a character string or vector/list of character strings. Specifies Blimp's WALDTEST command. See details.}

\item{options}{a character string or vector/list of character strings. Specifies Blimp's OPTIONS command.}

\item{transform}{a character string or vector/list of character strings. Specifies Blimp's TRANSFORM command.}

\item{dropout}{a character string, formula, or vector/list of character strings. Specifies Blimp's DROPOUT command. See details.}

\item{filter}{a character string. Specifies Blimp's FILTER command.}

\item{fixed}{a character string, formula, or vector/list of character strings. Specifies Blimp's FIXED command. See details.}

\item{output}{a character string or vector/list of character strings. Specifies Blimp's OUTPUT command}

\item{tmpfolder}{a character string. If specified \code{rblimp} will use the given
file path as a temporary directory instead of creating one with \code{\link{tempdir}}}

\item{add_save}{a single logical value or a list of logical values.
If \code{TRUE} then saveLatent, saveResidual, and savePredicted will be included in OPTIONS command.
Otherwise, it will be coerced to a list. The elements of the list should labeled \code{latent}, \code{residual}, and \code{predicted}
each containing a single logical value that can be used to toggle on or off them individually.
Missing elements will be defaulted to \code{TRUE}.}

\item{print_output}{The type of output printed to the console.
\code{'iteration'} or logical \code{TRUE} is only iteration history, \code{'none'} or logical \code{FALSE}
suppresses all output to console, and \code{'all'} prints all output to console.}

\item{nopowershell}{Windows only. Uses cmd.exe with some limited functions (instead of powershell).}

\item{variables}{list of variables to be included in FCS procedure}

\item{save}{Specify SAVE command for blimp syntax}
}
\value{
\code{\link{blimp_obj}}
}
\description{
\code{rblimp} will generate the input, run the script, and load most the saved data into an R object. \code{rblimp_fcs}
is used to specify the FCS command in Blimp. \code{rblimp_syntax} will generate the Blimp syntax file only.
}
\details{
The above functions require knowledge of specifying Blimp commands. Blimp's syntax commands are
documented in the \href{https://docs.google.com/document/d/1D3MS79CakuX9mVVvGH13B5nRd9XLttp69oGsvrIRK64/edit?usp=sharing}{Blimp User Manual}

By default, these commands can be inputted as character strings that will be used to generate the syntax.
For multiple lined commands, you can wrap multiple strings into a character \code{\link{vector}} or a \code{\link{list}}.
The appropriate semicolons will be specified, so they are not required in any character strings.
If specifying a character \code{\link{vector}} or a \code{\link{list}} for the \code{model}, providing names to each element
will be used as blocks in Blimp's model syntax. Similarly, specifying named elements can be used
for the \code{center} command to specify if you would like centering within a cluster or
grand mean centering. This also works for the \code{latent} input when requesting latent
variables at a specific cluster identifier.
See the \href{https://docs.google.com/document/d/1D3MS79CakuX9mVVvGH13B5nRd9XLttp69oGsvrIRK64/edit?usp=sharing}{Blimp User Manual}
for more details about types of centering and specifying latent variables.

In addition, R's formula syntax can be used to specify lists of variables
in place of character strings. For example, specifying the CLUSTERID command with
the variable \code{id} can be specified as \code{ ~ id} as opposed to a character string.
Similarly, \code{+} can be used to specify multiple variables. For example, to specify
two variables as ordinal the formula would be: \code{~ x1 + x2}. Finally, this can also be
used to specify centering and latent variables. For example, to center \code{x1} and \code{x2}
within cluster we can specify: \code{cwc ~ x1 + x2}.

Running \code{rblimp} will also check if blimp is up to date.
See details in \code{\link{rblimp_source}} for more information.
}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Generate Data with `rblimp_sim`
mydata <- rblimp_sim(
    c(
        'f ~ normal(0, 1)',
        'x1:x5 ~ normal(f, 1)',
        'y ~ normal(10 + 0.3*f, 1 - .3^2)'
     ),
     n = 500,
     seed = 19723,
     variables = c('y', 'x1:x5')
)

# Fit SEM Model
model <- rblimp(
    list(
        structure = 'y ~ f',
        measurement = 'f -> x1:x5'
    ),
    mydata,
    seed = 3927,
    latent = ~ f
)

# View results
summary(model)
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=SIMULATE]{SIMULATE()}} for creating simulated data to fit within \code{\link[=rblimp]{rblimp()}}
\item \code{\link[=rblimp_sim]{rblimp_sim()}} for generating simulated datasets
}
}
