% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_plot.R
\name{posterior_plot}
\alias{posterior_plot}
\title{Function to generate graph posterior density plots for parameters}
\usage{
posterior_plot(model, selector, ...)
}
\arguments{
\item{model}{an \code{\link{blimp_obj}}.}

\item{selector}{a name of a variable, a name of a parameter, a number of a parameter,
or a combination of any of them. If left empty, a plot of all parameters will be returned. See Examples.}

\item{...}{arguments passed to internally called \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap}} when used.}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot}} plot
}
\description{
Generates \code{\link[ggplot2:ggplot]{ggplot2::ggplot}} plots using \code{\link[ggplot2:geom_density]{ggplot2::geom_density}} based on the output from \code{\link{rblimp}}
}
\details{
To change colors use ggplot2's scale system. Both fill and color are used. See
\code{\link[ggplot2:aes_colour_fill_alpha]{ggplot2::aes_colour_fill_alpha}} for more information about setting a manual set of colors.
}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Generate Data
mydata <- rblimp_sim(
    c(
        'x ~ normal(0, 1)',
        'm ~ normal(0, 1)',
        'y ~ normal(10 + 0.5*x + m + 0.2*x*m, 1)'
    ),
    n = 100,
    seed = 981273
)

# Run Rblimp
m1 <- rblimp(
    c(
        'y ~ x m',
        'x ~~ m'
    ),
    mydata,
    seed = 10972,
    burn = 1000,
    iter = 1000
)

# Generate plot of all parameters with `y`
posterior_plot(m1, 'y') + ggplot2::theme_minimal()

# Generate plot of all parameters
posterior_plot(m1) + ggplot2::theme_minimal()

# Generate plot of all parameters for `y` and `x`
posterior_plot(m1, c('x', 'y')) + ggplot2::theme_minimal()
# Generate Plot of Parameter 5
posterior_plot(m1, 5) + ggplot2::theme_minimal()

# Generate plot of `x residual variance`
posterior_plot(m1, 'x residual variance') + ggplot2::theme_minimal()

# Generate plot of Parameters 7 and 9
posterior_plot(m1, c(7, 9)) + ggplot2::theme_minimal()
\dontshow{\}) # examplesIf}
}
