% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jn_plot.R
\name{compute_condeff}
\alias{compute_condeff}
\title{Convenience Function for computing conditional effects for \code{\link{jn_plot_func}}}
\usage{
compute_condeff(value1, value2)
}
\arguments{
\item{value1}{The base value}

\item{value2}{The value to change as a function of moderator}
}
\value{
a \code{\link{function}}
}
\description{
Convenience Function for computing conditional effects for \code{\link{jn_plot_func}}
}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Generate Data
mydata <- rblimp_sim(
    c(
        'x1 ~ normal(0, 1)',
        'x2 ~ normal(0, 1)',
        'm ~ normal(0, 1)',
        'y ~ normal(10 + 0.5*x1 + 0.5*x2 + m + 0.2*x1*x2 + 0.3*x2*m + 0.1*x1*m + 0.7*x1*x2*m, 1)'
    ),
    n = 100,
    seed = 981273
)

# Run Rblimp
m1 <- rblimp(
    'y ~ x1 x2 m x1*x2 x1*m x2*m x1*x2*m',
    mydata,
    center = ~ m,
    seed = 10972,
    burn = 1000,
    iter = 1000
)

# Get parameter values
params <- m1 |> as.matrix()

# Generate Plot
(
    jn_plot_func(
        compute_condeff(params[,6], params[,9]),
        xrange = c(-3, 3)
    )
    # Set custom colors
    + ggplot2::scale_fill_manual(
        values = c(`FALSE` = '#ca0020', `TRUE` = '#0571b0')
    )
    + ggplot2::labs(
        title = 'Johnson-Neyman Plot for `x1` * `x2` Moderated by `x2`',
        subtitle = 'Red area represents 0 within 95\% interval',
        y = 'y ~ x1 * x2',
        x = 'm'
    )
    + ggplot2::theme_minimal()
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=jn_plot_func]{jn_plot_func()}}
}
