#' @importFrom Formula as.Formula
DataFeatures <- R6::R6Class("DataFeatures",
  public = list(
    formula = NULL,
    n_maps = 0,
    model_frames = NULL,
    model_matrices = NULL,
    offsets = NULL,
    parameter_names = character(0),
    n_parameters = integer(0),
    parameter_groups = integer(0),
    linear_predictors = function(par) {
      Map(function(mat, vec, off) {
        if(is.null(off)) {
          mat %*% vec
          } else {
          mat %*% vec + off
          }
        },
      self$model_matrices,
      split(par, self$parameter_groups),
      self$offsets
      )
    },
    response = NULL,
    initialize = function(formula, data, response = FALSE) {
      self$formula <- Formula::as.Formula(formula)

      self$n_maps <- length(self$formula)[2]
      self$model_frames <- lapply(1:self$n_maps,
        function(j) {
          stats::model.frame(
            self$formula, data = data, lhs = 0, rhs = j)
        }
      )
      self$model_matrices <- lapply(self$model_frames,
        stats::model.matrix, data = data)
      self$offsets <- lapply(self$model_frames, stats::model.offset)
      self$parameter_names <- lapply(self$model_matrices,
        function(mat) dimnames(mat)[2][[1]])
      self$n_parameters <- lapply(self$parameter_names, length)
      self$parameter_groups <- factor(
        rep(seq_along(self$n_parameters), times = self$n_parameters),
        levels = 1:self$n_maps)
      if(response) {
        self$response <- Formula::model.part(
          self$formula, data = data, lhs = 1)[[1]]
      }
    }
  )
)
