% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randolist_to_db.R
\name{randolist_to_db}
\alias{randolist_to_db}
\title{Reformat a randolist object to the requirements of a database}
\usage{
randolist_to_db(
  randolist,
  target_db = c("REDCap", "secuTrial"),
  strata_enc = NA,
  rando_enc = NA
)
}
\arguments{
\item{randolist}{a randolist object from \code{randolist} or \code{blockrand}}

\item{target_db}{the target database, either "REDCap" or "secuTrial"}

\item{strata_enc}{a list of data frames with the encoding of each stratification
variable. Should have two columns - the value used in \code{randolist} and code with
the values used in the database. See the examples for details.}

\item{rando_enc}{a data frame with the randomization encoding}
}
\value{
dataframe with columns required for import into \code{target_db}
}
\description{
Databases generally require a specific format to be able to import a randomization
list. This function converts the randolist object to the format required by
REDCap or secuTrial.
}
\details{
\code{rando_enc} should contain an \code{arm} column containing the values supplied
to \code{randolist}, and a variable with the name required by the
database with the values that map to those in \code{arm}. See the examples.
}
\examples{
r <- randolist(10,
               strata = list(sex = c("M", "F")),
               arms = c("T1", "T2"))
randolist_to_db(r,
  rando_enc = data.frame(arm = c("T1", "T2"),
                        rando_res = c(1, 2)),
  strata_enc = list(sex = data.frame(sex = c("M", "F"),
                                    code = 1:2)),
  target_db = "REDCap")
randolist_to_db(r,
  rando_enc = data.frame(arm = c("T1", "T2"),
                         rando_res = c(1, 2)),
  strata_enc = list(sex = data.frame(sex = c("M", "F"),
                                     code = 1:2)),
  target_db = "secuTrial")
}
