/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.jpmml.rexp.RDataOutput;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpWriter;
import org.jpmml.rexp.RString;
import org.jpmml.rexp.SerializationUtil;

public class RPair
extends RExp {
    private RExp tag = null;
    private RExp value = null;
    private RPair next = null;

    public RPair(RExp tag, RExp value, RPair attributes) {
        super(attributes);
        this.setTag(tag);
        this.setValue(value);
    }

    @Override
    public void write(RDataOutput output) throws IOException {
        RExp tag = this.getTag();
        RExp value = this.getValue();
        RPair attributes = this.getAttributes();
        RPair next = this.getNext();
        int flags = 2;
        if (attributes != null) {
            flags = SerializationUtil.setHasAttributes(flags);
        }
        if (tag != null) {
            flags = SerializationUtil.setHasTag(flags);
        }
        output.writeInt(flags);
        if (attributes != null) {
            attributes.write(output);
        }
        if (tag != null) {
            RString string = (RString)tag;
            RExpWriter writer = output.getWriter();
            Map<Object, Integer> referenceTable = writer.getReferenceTable();
            Integer index = referenceTable.get(string.getValue());
            if (index == null) {
                referenceTable.put(string.getValue(), referenceTable.size() + 1);
                output.writeInt(1);
                string.write(output);
            } else {
                output.writeInt(255);
                output.writeInt(index);
            }
        }
        value.write(output);
        if (next != null) {
            next.write(output);
        } else {
            output.writeInt(254);
        }
    }

    public RPair getValue(int index) {
        RPair result = this;
        for (int i = 0; i < index; ++i) {
            if (result == null) {
                throw new IllegalArgumentException();
            }
            if (i == index) break;
            result = result.getNext();
        }
        return result;
    }

    public boolean tagEquals(String string) {
        RString tag = (RString)this.getTag();
        return Objects.equals(string, tag != null ? tag.getValue() : null);
    }

    public RExp getTag() {
        return this.tag;
    }

    void setTag(RExp tag) {
        this.tag = tag;
    }

    public RExp getValue() {
        return this.value;
    }

    void setValue(RExp value) {
        this.value = value;
    }

    public RPair getNext() {
        return this.next;
    }

    void setNext(RPair next) {
        this.next = next;
    }
}

