% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_codebook_immigration}
\alias{data_codebook_immigration}
\title{Immigration policy codebook based on Benoit et al. (2016)}
\format{
A \code{qlm_codebook} object containing:
\describe{
\item{name}{Task name: "Immigration policy coding from Benoit et al. (2016)"}
\item{instructions}{Coding instructions for identifying whether sentences
from UK 2010 election manifestos pertain to immigration policy, and if so,
rating the policy position expressed}
\item{schema}{Response schema with two fields: \code{llm_immigration_label}
(Enum: "Not immigration" or "Immigration" indicating whether the sentence
relates to immigration policy), and \code{llm_immigration_position} (Integer
from -1 to 1, where -1 = pro-immigration, 0 = neutral, and 1 =
anti-immigration)}
\item{input_type}{"text"}
\item{levels}{Named character vector: llm_immigration_label = "nominal",
llm_immigration_position = "ordinal"}
}
}
\usage{
data_codebook_immigration
}
\description{
A \code{qlm_codebook} object defining instructions for annotating whether a text
pertains to immigration policy and, if so, the stance toward immigration
openness. This codebook replicates the crowd-sourced annotation task from
Benoit et al. (2016) and is designed to work with
\link{data_corpus_manifsentsUK2010sample}.
}
\examples{
# View the codebook
data_codebook_immigration

\dontrun{
# Use with UK manifesto sentences (requires API key)
if (requireNamespace("quanteda", quietly = TRUE)) {
  coded <- qlm_code(data_corpus_manifsentsUK2010sample,
                    data_codebook_immigration,
                    model = "openai/gpt-4o-mini")

  # Compare with crowd-sourced annotations
  crowd <- as_qlm_coded(
    data.frame(
      .id = docnames(data_corpus_manifsentsUK2010sample),
      docvars(data_corpus_manifsentsUK2010sample)
    ),
    is_gold = TRUE
  )

  qlm_validate(coded, gold = crowd)

}
}
}
\references{
Benoit, K., Conway, D., Lauderdale, B.E., Laver, M., & Mikhaylov, S. (2016).
Crowd-sourced Text Analysis:
Reproducible and Agile Production of Political Data.
\emph{American Political Science Review}, 110(2), 278--295.
\doi{10.1017/S0003055416000058}
}
\seealso{
\code{\link[=qlm_codebook]{qlm_codebook()}}, \code{\link[=qlm_code]{qlm_code()}}, \link{data_corpus_manifsentsUK2010sample}
}
\keyword{data}
