% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_functions.R
\name{R.MLE.memory}
\alias{R.MLE.memory}
\title{Gaussian copula correlation matrix Maximum Likelihood estimator (memory handling)}
\usage{
R.MLE.memory(
  Hconfig,
  fHconfig_sum,
  OldPrior,
  Logf0Mat,
  Logf1Mat,
  zeta0,
  zeta1,
  OldR,
  OldRinv
)
}
\arguments{
\item{Hconfig}{A list of all possible combination of \eqn{H_0} and \eqn{H_1} hypotheses generated by the \link[=GetHconfig]{GetHconfig()} function.}

\item{fHconfig_sum}{a vector containing \eqn{\sum_c(w_c*psi_c)} for each items.}

\item{OldPrior}{a vector containing the prior probabilities for each of the H-configurations.}

\item{Logf0Mat}{a matrix containing \eqn{\log(f_0Mat)}, each column corresponding to a p-value serie.}

\item{Logf1Mat}{a matrix containing \eqn{\log(f_1Mat)}, each column corresponding to a p-value serie.}

\item{zeta0}{a matrix containing \code{qnorm(F0Mat)}, each column corresponding to a p-value serie.}

\item{zeta1}{a matrix containing \code{qnorm(F1Mat)}, each column corresponding to a p-value serie.}

\item{OldR}{the copula correlation matrix.}

\item{OldRinv}{the inverse of copula correlation matrix.}
}
\value{
Estimate of the correlation matrix.
}
\description{
Gaussian copula correlation matrix Maximum Likelihood estimator (memory handling)
}
