% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastKerFDR_functions.R
\name{FastKerFdr_unsigned}
\alias{FastKerFdr_unsigned}
\title{FastKerFdr unsigned}
\usage{
FastKerFdr_unsigned(
  X,
  p0 = NULL,
  plotting = FALSE,
  NbKnot = 1e+05,
  tol = 1e-05,
  max_iter = 10000
)
}
\arguments{
\item{X}{a vector of probit-transformed p-values (corresponding to a p-value serie)}

\item{p0}{a priori proportion of H0 hypotheses}

\item{plotting}{boolean, should some diagnostic graphs be plotted. Default is FALSE.}

\item{NbKnot}{The (maximum) number of knot for the kde procedure. Default is 1e5}

\item{tol}{a tolerance value for convergence. Default is 1e-5}

\item{max_iter}{the maximum number of iterations allowed for the algorithm to converge or complete its process.(Default is 1e4.)}
}
\value{
A list of 3 objects.
Object 'p0' is an estimate of the proportion of H0 hypotheses,
Object 'tau' is the vector of H1 posteriors,
Object 'f1' is a numeric vector, each coordinate i corresponding to the evaluation of the H1 density at point xi, where xi is the ith item in X.
Object 'F1' is a numeric vector, each coordinate i corresponding to the evaluation of the H1 ;cdf at point xi, where xi is the ith item in X.
}
\description{
FastKerFdr unsigned
}
