% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_main_function.R
\name{.NBmix_EM}
\alias{.NBmix_EM}
\title{Fit gamma mixture based empirical Bayes models using ECM algorithm.}
\usage{
.NBmix_EM(
  N,
  E,
  dirichlet = TRUE,
  alpha = NULL,
  K = NULL,
  maxi = NULL,
  h = NULL,
  eps = 1e-04
)
}
\arguments{
\item{N}{an IxJ contingency table showing pairwise counts of
adverse events for I AEs (along the rows) and J drugs (along the columns).}

\item{E}{A matrix of expected counts under the null model for the SRS
frequency table.}

\item{dirichlet}{logical. Used for "general-gamma" model. If is TRUE, a
dirichlet hyperprior for weights of gamma mixture prior is applied.}

\item{alpha}{numeric between 0 and 1. The hyperparameter of "general-gamma"
model. It is needed if "general-gamma" model is used.}

\item{K}{integer greater than or equal to 2. It is needed if "K-gamma" model
is used.}

\item{maxi}{upper limit of iteration for the ECM algorithm.}

\item{h}{a vector of initialization of parameter h.}

\item{eps}{a tolerance parameter for ECM algorithm.}
}
\value{
a list of optimizer outputs
}
\description{
Fit gamma mixture based empirical Bayes models using ECM algorithm.
}
\details{
This function implements the ECM algorithm proposed by Tan et al. (2025),
providing a stable and efficient implementation of Gamma-Poisson
Shrinker(GPS), K-gamma and "general-gamma" methods for signal estimation and
signal detection in Spontaneous Reporting System (SRS) data table.
}
\references{
Tan Y, Markatou M and Chakraborty S. Flexible Empirical Bayesian Approaches
to Pharmacovigilance for Simultaneous Signal Detection and Signal Strength
Estimation in Spontaneous Reporting Systems Data.
\emph{Statistics in Medicine.} 2025; 44: 18-19,
https://doi.org/10.1002/sim.70195.

DuMouchel W. Bayesian data mining in large frequency tables, with an
application to the FDA spontaneous reporting system.
\emph{The American Statistician.} 1999; 1;53(3):177-90. \cr
}
\keyword{internal}
