% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_ps_est.R
\name{psrwe_est}
\alias{psrwe_est}
\title{Estimate propensity scores}
\usage{
psrwe_est(
  data,
  ps_fml = NULL,
  ps_method = c("logistic", "randomforest"),
  v_covs = "V1",
  v_grp = "Group",
  cur_grp_level = 1,
  v_arm = NULL,
  ctl_arm_level = NULL,
  stra_ctl_only = TRUE,
  nstrata = 5,
  trim_ab = c("both", "above", "below", "none"),
  .drop_arg_fml = FALSE,
  ...
)
}
\arguments{
\item{data}{Data frame with group assignment and covariates.}

\item{ps_fml}{Propensity score (PS) formula. If \code{NULL}, all covariates
will be included in the PS model in a linear form.}

\item{ps_method}{Method to calculate propensity scores. Can be set to
\code{logistic} for logistic regression or \code{randomforest} for a
random forest approach.}

\item{v_covs}{Column names corresponding to covariates.}

\item{v_grp}{Column name corresponding to group assignment.}

\item{cur_grp_level}{Group level for the current study. Default is
\code{cur_grp_level = 1}. Ignored for single-arm studies.}

\item{v_arm}{Column name corresponding to arm assignment.}

\item{ctl_arm_level}{Arm level for the control arm. Ignored for single-arm
studies.}

\item{stra_ctl_only}{Create strata by control arm patients only. Default
\code{TRUE}. Ignored by single-arm studies. For randomized studies, when
\code{stra_ctl_only} is \code{FALSE}, strata are created based on the PS
scores of the entire current study patients.}

\item{nstrata}{Number of PS strata to be created.}

\item{trim_ab}{Trim external subjects who are above or below the
range of current study. Default \code{both} trims both above and below.
Other options include \code{above} for above only, \code{below} for
below only, and \code{none} for no trimming.}

\item{.drop_arg_fml}{internal use to drop arguments and call, this is
only used in cjk.}

\item{...}{Additional parameters for calculating the propensity score to be
used in \code{randomForest} or \code{glm} .}
}
\value{
A list of class \code{PSRWE_DAT} with items:

\describe{
  \item{data}{Original data with column \code{_ps_} for estimated PS scores
              and \code{_strata_} for PS stratum added.}
  \item{ps_fml}{PS formula for estimated PS scores.}
  \item{is_rct}{Whether the current study is a randomized study.}
  \item{nstrata}{Number of strata.}
}
}
\description{
Estimate propensity scores using logistic regression or random
  forest model.
}
\examples{
data(ex_dta)
psrwe_est(ex_dta,
       v_covs = paste("V", 1:7, sep = ""),
       v_grp = "Group",
       cur_grp_level = "current")

}
