% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_data}
\alias{simulate_data}
\alias{simulate_data.Raster}
\alias{simulate_data.SpatRaster}
\title{Simulate data}
\usage{
simulate_data(x, n, scale, intensity, sd, transform)

\method{simulate_data}{Raster}(
  x,
  n = 1,
  scale = 0.5,
  intensity = 0,
  sd = 1,
  transform = identity
)

\method{simulate_data}{SpatRaster}(
  x,
  n = 1,
  scale = 0.5,
  intensity = 0,
  sd = 1,
  transform = identity
)
}
\arguments{
\item{x}{\code{\link[terra:rast]{terra::rast()}} object to use as a template.}

\item{n}{\code{integer} number of layers to simulate.
Defaults to 1.}

\item{scale}{\code{numeric} parameter to control level of spatial
auto-correlation in the simulated data.
Defaults to 0.5.}

\item{intensity}{\code{numeric} average value of simulated data.
Defaults to 0.}

\item{sd}{\code{numeric} standard deviation of simulated data.
Defaults to 1.}

\item{transform}{\code{function} transform values output from the simulation.
Defaults to the \code{\link[=identity]{identity()}} function such that values remain the same
following transformation.}
}
\value{
A \code{\link[terra:rast]{terra::rast()}} object.
}
\description{
Simulate spatially auto-correlated data using Gaussian random fields.
}
\examples{
\dontrun{
# create raster
r <- terra::rast(
  ncols = 10, nrows = 10, xmin = 0, xmax = 1, ymin = 0, ymax = 1, vals = 1
)

# simulate data using a Gaussian field
x <- simulate_data(r, n = 1, scale = 0.2)

# plot simulated data
plot(x, main = "simulated data", axes = FALSE)
}
}
\seealso{
Other functions for simulating data:
\code{\link{simulate_cost}()},
\code{\link{simulate_species}()}
}
\concept{simulations}
