% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_rtree.R
\name{print_rtree}
\alias{print_rtree}
\title{Print an R Project or Directory Tree}
\usage{
print_rtree(
  path = NULL,
  ignore = c("renv", ".git", ".Rproj.user", "__pycache__", ".DS_Store", "node_modules",
    ".Rhistory"),
  max_depth = NULL,
  show_hidden = FALSE,
  project = c("auto", "root", "none"),
  search_paths = c(".", "..", "~/Documents", "~/Projects"),
  root_markers = c(".Rproj", "DESCRIPTION"),
  format = c("ascii", "unicode"),
  return_lines = FALSE,
  snapshot = FALSE,
  snapshot_file = "tree.png",
  snapshot_width = 800,
  snapshot_bg = c("white", "black"),
  snapshot_path = "."
)
}
\arguments{
\item{path}{Character. Directory path, project name, or \code{.Rproj} file. If NULL, uses ".".}

\item{ignore}{Character vector. Basenames to exclude (e.g., ".git", "renv").}

\item{max_depth}{Integer. Maximum depth to traverse. NULL for unlimited.}

\item{show_hidden}{Logical (TRUE/FALSE). Whether to include hidden files/directories (starting with ".").}

\item{project}{One of "auto", "root", "none".
\itemize{
\item "auto": use \code{path} as-is (only resolves project name / .Rproj file)
\item "root": walk upward from \code{path} to find a project root (via \code{root_markers}) and use it if found
\item "none": never attempt root detection; print the tree from \code{path}
}}

\item{search_paths}{Character vector. Used only when \code{path} is not an existing directory
(treated as a project name). Paths are searched in order.}

\item{root_markers}{Character vector. Markers used when \code{project = "root"} to detect a root directory.
Special value ".Rproj" means "any file ending in .Rproj". Common markers include "DESCRIPTION"
(R package root) and "_quarto.yml" (Quarto project root).}

\item{format}{One of "ascii" or "unicode". "ascii" is portable for all terminals.}

\item{return_lines}{Logical. If TRUE, invisibly return the printed character vector of lines.}

\item{snapshot}{Logical. If TRUE, saves a PNG snapshot of the tree.}

\item{snapshot_file}{Character. Snapshot PNG filename (or full path).}

\item{snapshot_width}{Integer. PNG width in pixels.}

\item{snapshot_bg}{One of "white" or "black" for snapshot background.}

\item{snapshot_path}{Character. Directory to save snapshot_file in when snapshot_file is not absolute.}
}
\value{
Invisible NULL, or a character vector of printed lines if \code{return_lines = TRUE}.
}
\description{
Prints a directory tree for a given path. Optionally detects an RStudio project
(\code{.Rproj}) and can print from a project root.
}
\examples{
demo <- file.path(tempdir(), "printtree-demo")
if (dir.exists(demo)) unlink(demo, recursive = TRUE)
dir.create(demo, recursive = TRUE)
dir.create(file.path(demo, "R"))
file.create(file.path(demo, "R", "hello.R"))
file.create(file.path(demo, "README.md"))

print_rtree(demo)
print_rtree(demo, max_depth = 1)

png_file <- tempfile(fileext = ".png")
print_rtree(demo, snapshot = TRUE, snapshot_file = png_file)
}
