ppweibull <-
function(q, rate = 1, alpha = 1, t = 0, lower.tail = TRUE, log.p = FALSE) 
{
    if (length(t) != length(rate)) 
        stop("length of t must be equal to length of rate")
    if (length(t) != length(alpha)) 
        stop("length of t must be equal to length of alpha")
    if (!isTRUE(all.equal(0, t[1]))) 
        stop("first element of t should be 0")
    if (any(alpha<0)) 
        stop("alpha's should be positive values")
    if (is.unsorted(t)) 
        stop("t should be in increasing order")
    q[q < 0] <- 0
    ind <- rowSums(outer(q, t, ">="))
    ret <- pexp(q^alpha[ind] - t[ind]^alpha[ind], rate[ind])
    mi <- min(length(t), max(ind))
    if (length(t) > 1) {
        dt <- t[-1]^alpha[-mi] - t[-mi]^alpha[-mi]
        pe <- pexp(dt, rate[-mi])
        cp <- c(1, cumprod(1 - pe))
        ret <- c(0, cumsum(cp[-length(cp)] * pe))[ind] + ret * 
            cp[ind]
    }
    if (!lower.tail) 
        ret <- 1 - ret
    if (log.p) 
        ret <- log(ret)
    ret
}
