% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.pmrm_fit}
\alias{confint.pmrm_fit}
\title{Confidence intervals of parameters}
\usage{
\method{confint}{pmrm_fit}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{parm}{a specification of which parameters are to be given
    confidence intervals, either a vector of numbers or a vector of
    names.  If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional argument(s) for methods.}
}
\value{
A numeric matrix with one row for each treatment effect
parameter (\code{theta}) and named columns with the lower and upper
bounds of 2-sided confidence intervals on the parameters.
}
\description{
Compute confidence intervals of the family of model
parameters specified in \code{parm}.
}
\details{
See \code{vignette("models", package = "pmrm")} for details.
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  confint(fit)
}
\seealso{
Other model comparison: 
\code{\link{AIC.pmrm_fit}()},
\code{\link{BIC.pmrm_fit}()},
\code{\link{deviance.pmrm_fit}()},
\code{\link{glance.pmrm_fit}()},
\code{\link{logLik.pmrm_fit}()},
\code{\link{summary.pmrm_fit}()}
}
\concept{model comparison}
