% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pix_transactions_municipality.R
\name{get_pix_transactions_by_municipality}
\alias{get_pix_transactions_by_municipality}
\title{Get PIX Transactions by Municipality}
\usage{
get_pix_transactions_by_municipality(
  database,
  filter = NULL,
  columns = NULL,
  top = NULL,
  skip = NULL,
  orderby = NULL,
  verbose = TRUE
)
}
\arguments{
\item{database}{Character string in "YYYYMM" format specifying which month's
data to retrieve. This parameter is \strong{required}.}

\item{filter}{OData filter expression as a character string. Examples:
\itemize{
\item \code{"Estado eq 'SÃO PAULO'"} - Filter by state name
\item \code{"Sigla_Regiao eq 'SE'"} - Filter by region
\item \code{"Municipio eq 'RECIFE'"} - Filter by municipality name
}}

\item{columns}{Character vector of columns to return. If NULL, returns all
columns. See "Available Columns" section.}

\item{top}{Integer; maximum number of records to return.}

\item{skip}{Integer; number of records to skip (for pagination).}

\item{orderby}{Character string specifying the column to sort by. Use
\code{"Column"} for ascending or \code{"Column desc"} for descending order.}

\item{verbose}{Logical; if TRUE (default), prints progress messages.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with PIX transaction data by municipality.
}
\description{
Retrieves PIX transaction statistics aggregated by municipality, showing
the number and value of transactions from the perspective of both payers
and receivers.
}
\details{
The BCB PIX API requires a \code{database} parameter (YYYYMM format) specifying
which month's data to retrieve. The data is broken down by municipality,
person type (PF/PJ), and transaction direction (payer/receiver).
}
\section{Available Columns}{

\describe{
\item{AnoMes}{Reference year-month in YYYYMM format}
\item{Municipio_Ibge}{IBGE municipality code}
\item{Municipio}{Municipality name}
\item{Estado_Ibge}{IBGE state code}
\item{Estado}{State name}
\item{Sigla_Regiao}{Region abbreviation (NE, SE, S, CO, N)}
\item{Regiao}{Region name (NORDESTE, SUDESTE, SUL, CENTRO-OESTE, NORTE)}
\item{VL_PagadorPF}{Total value paid by individuals (BRL)}
\item{QT_PagadorPF}{Number of transactions where individuals were payers}
\item{VL_PagadorPJ}{Total value paid by legal entities (BRL)}
\item{QT_PagadorPJ}{Number of transactions where legal entities were payers}
\item{VL_RecebedorPF}{Total value received by individuals (BRL)}
\item{QT_RecebedorPF}{Number of transactions where individuals were receivers}
\item{VL_RecebedorPJ}{Total value received by legal entities (BRL)}
\item{QT_RecebedorPJ}{Number of transactions where legal entities were receivers}
\item{QT_PES_PagadorPF}{Number of distinct individual payers}
\item{QT_PES_PagadorPJ}{Number of distinct legal entity payers}
\item{QT_PES_RecebedorPF}{Number of distinct individual receivers}
\item{QT_PES_RecebedorPJ}{Number of distinct legal entity receivers}
}
}

\examples{
\donttest{# It usually takes much longer than 5 seconds.
# Get municipality transaction data for December 2025
muni <- get_pix_transactions_by_municipality(database = "202512")

# Filter by state
maranhao <- get_pix_transactions_by_municipality(
  database = "202512",
  filter = "Estado eq 'MARANHÃO'",
  orderby = "Municipio desc",
  top = 10
)

# Filter by region
nordeste <- get_pix_transactions_by_municipality(
  database = "202512",
  filter = "Sigla_Regiao eq 'NE'"
)

# Order by value
top_value <- get_pix_transactions_by_municipality(
  database = "202512",
  orderby = "VL_PagadorPF desc",
  top = 100
)
}
}
