
<!-- README.md is generated from README.Rmd. Please edit that file -->

# pipr

<!-- badges: start -->

[![R-CMD-check](https://github.com/worldbank/pipr/workflows/R-CMD-check/badge.svg)](https://github.com/worldbank/pipr/actions?workflow=R-CMD-check)
[![test-coverage](https://github.com/worldbank/pipr/workflows/test-coverage/badge.svg)](https://github.com/worldbank/pipr/actions)
[![pkgdown](https://github.com/worldbank/pipr/workflows/pkgdown/badge.svg)](https://github.com/worldbank/pipr/actions)
[![Codecov test
coverage](https://codecov.io/gh/worldbank/pipr/branch/main/graph/badge.svg)](https://app.codecov.io/gh/worldbank/pipr?branch=main)
[![Lifecycle:
stable](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
[![R-CMD-check](https://github.com/worldbank/pipr/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/worldbank/pipr/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/worldbank/pipr/graph/badge.svg)](https://app.codecov.io/gh/worldbank/pipr)
<!-- badges: end -->

The `pipr` package allows R users to compute poverty and inequality
indicators for more than 160 countries and regions from the World Bank’s
database of household surveys. It does so by accessing the Poverty and
Inequality Platform (PIP) API. PIP is a computational tool that allows
users to estimate poverty rates for regions, sets of countries or
individual countries, over time and at any poverty line.

## Installation

You can install the development version from
[GitHub](https://github.com/) with:

``` r
# From CRAN
install.packages("devtools")

# From Github
devtools::install_github("worldbank/pipr")
```

## Example

This is a basic example that shows how to retrieve some key poverty and
inequity statistics.

### Retrieve statistics

``` r
library(dplyr)
library(pipr)

df <- get_stats(country = "ALB")
glimpse(df)
#> Rows: 15
#> Columns: 44
#> $ region_name          <chr> "Europe & Central Asia", "Europe & Central Asia",…
#> $ region_code          <chr> "ECA", "ECA", "ECA", "ECA", "ECA", "ECA", "ECA", …
#> $ country_name         <chr> "Albania", "Albania", "Albania", "Albania", "Alba…
#> $ country_code         <chr> "ALB", "ALB", "ALB", "ALB", "ALB", "ALB", "ALB", …
#> $ year                 <dbl> 1996, 2002, 2005, 2008, 2012, 2014, 2015, 2016, 2…
#> $ reporting_level      <chr> "national", "national", "national", "national", "…
#> $ survey_acronym       <chr> "EWS", "LSMS", "LSMS", "LSMS", "LSMS", "HBS", "HB…
#> $ survey_coverage      <chr> "national", "national", "national", "national", "…
#> $ welfare_time         <dbl> 1996, 2002, 2005, 2008, 2012, 2014, 2015, 2016, 2…
#> $ welfare_type         <chr> "consumption", "consumption", "consumption", "con…
#> $ survey_comparability <dbl> 0, 1, 1, 1, 1, 2, 2, 2, 4, 2, 4, 3, 4, 3, 3
#> $ comparable_spell     <chr> "1996", "2002 - 2012", "2002 - 2012", "2002 - 201…
#> $ poverty_line         <dbl> 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
#> $ headcount            <dbl> 0.029678411, 0.041947222, 0.026502176, 0.00827307…
#> $ poverty_gap          <dbl> 0.0043977900, 0.0072032820, 0.0040605484, 0.00135…
#> $ poverty_severity     <dbl> 1.176030e-03, 2.111000e-03, 1.064328e-03, 3.86292…
#> $ watts                <dbl> 0.0052255168, 0.0087713516, 0.0047720677, 0.00161…
#> $ mean                 <dbl> 8.442033, 8.628334, 9.753929, 10.682071, 10.12771…
#> $ median               <dbl> 7.419330, 7.117154, 8.300111, 8.939033, 8.768967,…
#> $ mld                  <dbl> 0.1191043, 0.1648116, 0.1544128, 0.1488934, 0.138…
#> $ gini                 <dbl> 0.2701034, 0.3173898, 0.3059566, 0.2998467, 0.289…
#> $ polarization         <dbl> 0.2412933, 0.2689816, 0.2545287, 0.2473111, 0.249…
#> $ decile1              <dbl> 0.03881788, 0.03523453, 0.03487046, 0.03738298, 0…
#> $ decile2              <dbl> 0.05279230, 0.04848445, 0.04936295, 0.05143395, 0…
#> $ decile3              <dbl> 0.06370657, 0.05852072, 0.05965820, 0.06098502, 0…
#> $ decile4              <dbl> 0.07524026, 0.06737630, 0.06935466, 0.06984726, 0…
#> $ decile5              <dbl> 0.08346224, 0.07640787, 0.07965423, 0.07901133, 0…
#> $ decile6              <dbl> 0.09245731, 0.08838444, 0.09039091, 0.08937947, 0…
#> $ decile7              <dbl> 0.1077896, 0.1023247, 0.1040651, 0.1028830, 0.105…
#> $ decile8              <dbl> 0.1261162, 0.1198690, 0.1210287, 0.1192047, 0.122…
#> $ decile9              <dbl> 0.1525077, 0.1499992, 0.1482984, 0.1454680, 0.148…
#> $ decile10             <dbl> 0.2071100, 0.2533988, 0.2433163, 0.2444043, 0.229…
#> $ cpi                  <dbl> 0.3724766, 0.6539548, 0.7027200, 0.7643803, 0.854…
#> $ ppp                  <dbl> 50.7723, 50.7723, 50.7723, 50.7723, 50.7723, 50.7…
#> $ pop                  <dbl> 3168033, 3051010, 3011487, 2947314, 2900401, 2889…
#> $ gdp                  <dbl> 1633.552, 2247.498, 2675.509, 3298.479, 3736.340,…
#> $ hfce                 <dbl> 1716.337, 1685.203, 2079.203, 2820.280, 2990.397,…
#> $ is_interpolated      <lgl> FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, …
#> $ distribution_type    <chr> "micro", "micro", "micro", "micro", "micro", "mic…
#> $ estimation_type      <chr> "survey", "survey", "survey", "survey", "survey",…
#> $ spl                  <dbl> 5.010, 4.859, 5.450, 5.770, 5.684, 5.714, 6.644, …
#> $ spr                  <dbl> 0.2039019, 0.2244040, 0.2099751, 0.1726098, 0.189…
#> $ pg                   <dbl> 4.209428, 4.429310, 3.860997, 3.450628, 3.634575,…
#> $ estimate_type        <chr> NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, N…
```

### Access data dictionary

``` r
get_aux("dictionary")
#> # A tibble: 41 × 2
#>    variable        definition                                                   
#>    <chr>           <chr>                                                        
#>  1 region_name     World Bank region name                                       
#>  2 region_code     Three-letter World Bank abbreviation of world regions        
#>  3 year            Year                                                         
#>  4 country_name    World Bank country name                                      
#>  5 country_code    Three-letter ISO (alpha-3) country code system for internati…
#>  6 reporting_level Reporting level                                              
#>  7 survey_acronym  Country survey acronym                                       
#>  8 survey_coverage Geographic coverage of the country survey (i.e. national, ur…
#>  9 welfare_time    Welfare time                                                 
#> 10 welfare_type    Type of welfare vector used for estimates (income or consump…
#> # ℹ 31 more rows
```

## Citation

To cite package `pipr` in publications use:

      Tony Fujs, Aleksander Eilertsen, Ronak Shah and R. Andrés Castañeda (2022). pipr: Client for the PIP
      API. https://github.com/worldbank/pipr, https://worldbank.github.io/pipr/.

A BibTeX entry for LaTeX users is

      @Manual{,
        title = {pipr: Client for the PIP API},
        author = {Tony Fujs and Aleksander Eilertsen and Ronak Shah and R. Andrés Castañeda},
        year = {2022},
        note = {https://github.com/worldbank/pipr,https://worldbank.github.io/pipr/},
      }
