% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phinterval.R
\name{as_duration}
\alias{as_duration}
\alias{as_duration.default}
\alias{as_duration.phinterval}
\title{Convert a phinterval to a duration}
\usage{
as_duration(x, ...)

\method{as_duration}{default}(x, ...)

\method{as_duration}{phinterval}(x, ...)
}
\arguments{
\item{x}{\verb{[phinterval / Interval]}

An object to convert.}

\item{...}{Parameters passed to other methods. Currently unused.}
}
\value{
A \verb{<Duration>} vector the same length as \code{x}.
}
\description{
\code{as_duration()} converts a \code{\link[lubridate:interval]{lubridate::interval()}} or \code{\link[=phinterval]{phinterval()}} vector
into a \code{\link[lubridate:duration]{lubridate::duration()}} vector. The resulting duration measures the
length of time in seconds within each element of the interval or phinterval.

\code{as_duration()} is a wrapper around \code{\link[lubridate:as.duration]{lubridate::as.duration()}}.
}
\examples{
monday <- interval(as.Date("2025-11-10"), as.Date("2025-11-11"))
friday <- interval(as.Date("2025-11-14"), as.Date("2025-11-15"))
mon_and_fri <- phint_union(monday, friday)

as_duration(c(mon_and_fri, monday))
as_duration(mon_and_fri) == as_duration(monday) + as_duration(friday)

}
