% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adoe_ophtha.R
\docType{data}
\name{adoe_ophtha}
\alias{adoe_ophtha}
\title{Exam Analysis for Ophthalmology}
\format{
A data frame with 103 columns:
\describe{
\item{ STUDYID }{Study Identifier}
\item{ USUBJID }{Unique Subject Identifier}
\item{ SUBJID }{Subject Identifier for the Study}
\item{ SITEID }{Study Site Identifier}
\item{ COUNTRY }{Country}
\item{ DOMAIN }{Domain Abbreviation}
\item{ RFSTDTC }{Subject Reference Start Date/Time}
\item{ RFENDTC }{Subject Reference End Date/Time}
\item{ RFXSTDTC }{Date/Time of First Study Treatment}
\item{ RFXENDTC }{Date/Time of Last Study Treatment}
\item{ RFPENDTC }{Date/Time of End of Participation}
\item{ SCRFDT }{Screen Failure Date}
\item{ FRVDT }{Final Retrieval Visit Date}
\item{ DTHDTC }{Date/Time of Death}
\item{ DTHADY }{Relative Day of Death}
\item{ DTHFL }{Subject Death Flag}
\item{ LDDTHELD }{Elapsed Days from Last Dose to Death}
\item{ LDDTHGR1 }{Last Dose to Death - Days Elapsed Grp 1}
\item{ DTH30FL }{Death Within 30 Days of Last Trt Flag}
\item{ DTHA30FL }{Death After 30 Days from Last Trt Flag}
\item{ DTHDOM }{Domain for Date of Death Collection}
\item{ DTHB30FL }{Death Within 30 Days of First Trt Flag}
\item{ ASEQ }{Analysis Sequence Number}
\item{ REGION1 }{Geographic Region 1}
\item{ DMDTC }{Date/Time of Collection}
\item{ DMDY }{Study Day of Collection}
\item{ AGE }{Age}
\item{ AGEU }{Age Units}
\item{ AGEGR1 }{Pooled Age Group 1}
\item{ SEX }{Sex}
\item{ RACE }{Race}
\item{ RACEGR1 }{Pooled Race Group 1}
\item{ ETHNIC }{Ethnicity}
\item{ SAFFL }{Safety Population Flag}
\item{ ARM }{Description of Planned Arm}
\item{ ARMCD }{Planned Arm Code}
\item{ ACTARM }{Description of Actual Arm}
\item{ ACTARMCD }{Actual Arm Code}
\item{ TRT01P }{Planned Treatment for Period 01}
\item{ TRT01A }{Actual Treatment for Period 01}
\item{ TRTSDT }{Date of First Exposure to Treatment}
\item{ TRTSDTM }{Datetime of First Exposure to Treatment}
\item{ TRTSTMF }{Time of First Exposure Imput. Flag}
\item{ TRTEDT }{Date of Last Exposure to Treatment}
\item{ TRTEDTM }{Datetime of Last Exposure to Treatment}
\item{ TRTETMF }{Time of Last Exposure Imput. Flag}
\item{ EOSSTT }{End of Study Status}
\item{ EOSDT }{End of Study Date}
\item{ RFICDTC }{Date/Time of Informed Consent}
\item{ RANDDT }{Date of Randomization}
\item{ LSTALVDT }{Date Last Known Alive}
\item{ TRTDURD }{Total Treatment Duration (Days)}
\item{ DTHDT }{Date of Death}
\item{ DTHDTF }{Date of Death Imputation Flag}
\item{ DTHCAUS }{Cause of Death}
\item{ DTHCGR1 }{Cause of Death Reason 1}
\item{ ADT }{Analysis Date}
\item{ ADY }{Analysis Relative Day}
\item{ AVISIT }{Analysis Visit}
\item{ AVISITN }{Analysis Visit (N)}
\item{ ATPT }{Analysis Timepoint}
\item{ ATPTN }{Analysis Timepoint (N)}
\item{ PARAM }{Parameter}
\item{ PARAMCD }{Parameter Code}
\item{ PARAMN }{Parameter (N)}
\item{ AVAL }{Analysis Value}
\item{ AVALC }{Analysis Value (C)}
\item{ AVALU }{Analysis Value Unit}
\item{ BASE }{Baseline Value}
\item{ BASEC }{Baseline Value (C)}
\item{ BASETYPE }{Baseline Type}
\item{ CHG }{Change from Baseline}
\item{ PCHG }{Percent Change from Baseline}
\item{ DTYPE }{Derivation Type}
\item{ ABLFL }{Baseline Record Flag}
\item{ ANL01FL }{Analysis Flag 01}
\item{ ANL02FL }{Analysis Flag 02}
\item{ ONTRTFL }{On Treatment Record Flag}
\item{ OESEQ }{Sequence Number}
\item{ OECAT }{Category for Ophthalmic Test or Exam}
\item{ OESCAT }{Subcategory for Ophthalmic Test or Exam}
\item{ OEDTC }{Date/Time of Collection}
\item{ VISIT }{Visit Name}
\item{ VISITNUM }{Visit Number}
\item{ VISITDY }{Planned Study Day of Visit}
\item{ OESTRESN }{Numeric Result/Finding in Standard Units}
\item{ OESTRESC }{Character Result/Finding in Std Format}
\item{ OEORRES }{Result or Finding in Original Units}
\item{ OETEST }{Name of Ophthalmic Test or Exam}
\item{ OETESTCD }{Short Name of Ophthalmic Test or Exam}
\item{ OETSTDTL }{Ophthalmic Test or Exam Detail}
\item{ OELAT }{Laterality}
\item{ OELOC }{Location Used for the Measurement}
\item{ OEDY }{Study Day of Visit/Collection/Exam}
\item{ OEMETHOD }{Method of Test or Examination}
\item{ OEORRESU }{Original Units}
\item{ OESTRESU }{Standard Units}
\item{ OESTAT }{Completion Status}
\item{ OETPT }{Planned Time Point Name}
\item{ OETPTNUM }{Planned Time Point Number}
\item{ STUDYEYE }{Study Eye Location}
\item{ AFEYE }{Affected Eye}
\item{ WORS01FL }{Worst Post Baseline Obs}
}
}
\source{
Generated from admiralophtha package (template ad_adoe.R).
}
\usage{
adoe_ophtha
}
\description{
Exam Analysis for Ophthalmology
}
\details{
Contains a set of 8 unique Parameter Codes and Parameters: \tabular{ll}{
\strong{PARAMCD} \tab \strong{PARAM} \cr
FCSUBTH \tab Fellow Eye Center Subfield Thickness (um)  \cr
FDRSSR  \tab Fellow Eye Diabetic Retinopathy Severity   \cr
FIOP    \tab Fellow Eye IOP (mmHg)                      \cr
FIOPCHG \tab Fellow Eye IOP Pre to Post Dose Diff (mmHg)\cr
SCSUBTH \tab Study Eye Center Subfield Thickness (um)   \cr
SDRSSR  \tab Study Eye Diabetic Retinopathy Severity    \cr
SIOP    \tab Study Eye IOP (mmHg)                       \cr
SIOPCHG \tab Study Eye IOP Pre to Post Dose Diff (mmHg)
}
}
\examples{
data("adoe_ophtha")
}
\references{
None
}
\keyword{dataset}
\keyword{ophthalmology}
