% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adface_vaccine.R
\docType{data}
\name{adface_vaccine}
\alias{adface_vaccine}
\title{Findings About Clinical Events Analysis}
\format{
A data frame with 61 columns:
\describe{
\item{ STUDYID }{Study Identifier}
\item{ USUBJID }{Unique Subject Identifier}
\item{ SUBJID }{Subject Identifier for the Study}
\item{ SITEID }{Study Site Identifier}
\item{ AGE }{Age}
\item{ AGEU }{Age Units}
\item{ SEX }{Sex}
\item{ RACE }{Race}
\item{ SAFFL }{Safety Population Flag}
\item{ ARM }{Description of Planned Arm}
\item{ ARMCD }{Planned Arm Code}
\item{ ACTARM }{Description of Actual Arm}
\item{ ACTARMCD }{Actual Arm Code}
\item{ TRTP }{Planned Treatment}
\item{ TRTA }{Actual Treatment}
\item{ TRT01P }{Planned Treatment for Period 01}
\item{ TRT01A }{Actual Treatment for Period 01}
\item{ TRT02P }{Planned Treatment for Period 02}
\item{ TRT02A }{Actual Treatment for Period 02}
\item{ TRTSDT }{Date of First Exposure to Treatment}
\item{ TRTSDTM }{Datetime of First Exposure to Treatment}
\item{ TRTEDT }{Date of Last Exposure to Treatment}
\item{ TRTEDTM }{Datetime of Last Exposure to Treatment}
\item{ APERSDT }{Period Start Date}
\item{ APEREDT }{Period End Date}
\item{ ADT }{Analysis Date}
\item{ ADTM }{Analysis Datetime}
\item{ ADY }{Analysis Relative Day}
\item{ ATPT }{Analysis Timepoint}
\item{ ATPTN }{Analysis Timepoint (N)}
\item{ ATPTREF }{Analysis Timepoint Reference}
\item{ APERIOD }{Period}
\item{ PARAM }{Parameter}
\item{ PARAMCD }{Parameter Code}
\item{ PARAMN }{Parameter (N)}
\item{ PARCAT1 }{Parameter Category 1}
\item{ PARCAT2 }{Parameter Category 2}
\item{ AVAL }{Analysis Value}
\item{ AVALC }{Analysis Value (C)}
\item{ ANL01FL }{Analysis Flag 01}
\item{ ANL02FL }{Analysis Flag 02}
\item{ ANL03FL }{Analysis Flag 03}
\item{ FATEST }{Findings About Test Name}
\item{ FALNKID }{Link ID}
\item{ FALNKGRP }{Link Group ID}
\item{ FATESTCD }{Findings About Test Short Name}
\item{ FAOBJ }{Object of the Observation}
\item{ FASTAT }{Completion Status}
\item{ FAREASND }{Reason Not Performed}
\item{ FAEVAL }{Evaluator}
\item{ EPOCH }{Epoch}
\item{ FAEVINTX }{Evaluation Interval Text}
\item{ EXDOSE }{Dose}
\item{ EXTRT }{Name of Treatment}
\item{ EXSTDTC }{Start Date/Time of Treatment}
\item{ EXENDTC }{End Date/Time of Treatment}
\item{ FAORRES }{Result or Finding in Original Units}
\item{ VAX01DT }{Vaccination Date 01}
\item{ VAX02DT }{Vaccination Date 02}
\item{ EVENTFL }{Event Value Flag}
\item{ EVENTDFL }{Day Event Value Flag}
}
}
\source{
Generated from admiralvaccine package (template ad_adface.R).
}
\usage{
adface_vaccine
}
\description{
Findings About Clinical Events Analysis
}
\details{
Contains a set of 30 unique Parameter Codes and Parameters: \tabular{ll}{
\strong{PARAMCD} \tab \strong{PARAM} \cr
DIARE    \tab Redness diameter deltoid muscle left                           \cr
DIASWEL  \tab Swelling diameter deltoid muscle left                          \cr
MAXREDN  \tab Redness maximum severity deltoid muscle left                   \cr
MAXSFAT  \tab Fatigue maximum severity                                       \cr
MAXSHEA  \tab Headache maximum severity                                      \cr
MAXSPIS  \tab Pain at injection site maximum severity deltoid muscle left    \cr
MAXSWEL  \tab Swelling maximum severity deltoid muscle left                  \cr
MAXTEMP  \tab Fever maximum temperature                                      \cr
MDIRE    \tab Redness maximum diameter deltoid muscle left                   \cr
MDISW    \tab Swelling maximum diameter deltoid muscle left                  \cr
MSEVNWJP \tab New or worsened joint pain maximum severity                    \cr
MSEVNWMP \tab New or worsened muscle pain maximum severity                   \cr
OCCHILLS \tab Chills occurrence indicator                                    \cr
OCCNWJP  \tab New or worsened joint pain occurrence indicator                \cr
OCCNWMP  \tab New or worsened muscle pain occurrence indicator               \cr
OCCVOM   \tab Vomiting occurrence indicator                                  \cr
OCDIAR   \tab Diarrhea occurrence indicator                                  \cr
OCFATIG  \tab Fatigue occurrence indicator                                   \cr
OCFEVER  \tab Fever occurrence indicator                                     \cr
OCHEAD   \tab Headache occurrence indicator                                  \cr
OCINS    \tab Swelling occurrence indicator deltoid muscle left              \cr
OCISR    \tab Redness occurrence indicator deltoid muscle left               \cr
OCPIS    \tab Pain at injection site occurrence indicator deltoid muscle left\cr
SEVFAT   \tab Fatigue severity/intensity                                     \cr
SEVHEAD  \tab Headache severity/intensity                                    \cr
SEVNWJP  \tab New or worsened joint pain severity/intensity                  \cr
SEVNWMP  \tab New or worsened muscle pain severity/intensity                 \cr
SEVPIS   \tab Pain at injection site severity/intensity deltoid muscle left  \cr
SEVREDN  \tab Redness severity/intensity deltoid muscle left                 \cr
SEVSWEL  \tab Swelling severity/intensity deltoid muscle left
}
}
\examples{
data("adface_vaccine")
}
\references{
None
}
\keyword{dataset}
\keyword{vaccine}
