% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adab.R
\docType{data}
\name{adab}
\alias{adab}
\title{Anti-Drug Antibody Analysis Dataset}
\format{
A data frame with 72 columns:
\describe{
\item{ STUDYID }{Study Identifier}
\item{ USUBJID }{Unique Subject Identifier}
\item{ SUBJID }{Subject Identifier for the Study}
\item{ SITEID }{Study Site Identifier}
\item{ ASEQ }{Analysis Sequence Number}
\item{ REGION1 }{Geographic Region 1}
\item{ COUNTRY }{Country}
\item{ ETHNIC }{Ethnicity}
\item{ AGE }{Age}
\item{ AGEU }{Age Units}
\item{ SEX }{Sex}
\item{ RACE }{Race}
\item{ SAFFL }{Safety Population Flag}
\item{ TRT01P }{Description of Planned Arm}
\item{ TRT01A }{Description of Actual Arm}
\item{ TRTSDTM }{Datetime of First Exposure to Treatment}
\item{ TRTSDT }{Date of First Exposure to Treatment}
\item{ TRTEDTM }{Datetime of Last Exposure to Treatment}
\item{ TRTEDT }{Date of Last Exposure to Treatment}
\item{ ISSEQ }{Sequence Number}
\item{ ISTESTCD }{Immunogenicity Test/Exam Short Name}
\item{ ISTEST }{Immunogenicity Test or Examination Name}
\item{ ISCAT }{Category for Immunogenicity Test}
\item{ ISBDAGNT }{Binding Agent}
\item{ ISSTRESC }{Character Result/Finding in Std Format}
\item{ ISSTRESN }{Numeric Results/Findings in Std. Units}
\item{ ISSTRESU }{Standard Units}
\item{ ISSTAT }{Completion Status}
\item{ ISREASND }{Reason Not Done}
\item{ ISSPEC }{Specimen Type}
\item{ DTL }{Drug Tolerance Level}
\item{ MRT }{Minimum Reportable Titer}
\item{ VISITNUM }{Visit Number}
\item{ VISIT }{Visit Name}
\item{ VISITDY }{Planned Study Day of Visit}
\item{ EPOCH }{Epoch}
\item{ ISDTC }{Date/Time of Collection}
\item{ ISDY }{Study Day of Visit/Collection/Exam}
\item{ ISTPT }{Planned Time Point Name}
\item{ ISTPTNUM }{Planned Time Point Number}
\item{ PARAM }{Parameter}
\item{ PARAMCD }{Parameter Code}
\item{ PARCAT1 }{Parameter Category 1}
\item{ AVAL }{Analysis Value}
\item{ AVALC }{Analysis Value (C)}
\item{ AVALU }{Analysis Value Unit}
\item{ BASETYPE }{Baseline Type}
\item{ BASE }{Baseline Value}
\item{ CHG }{Change from Baseline}
\item{ DTYPE }{Derivation Type}
\item{ ADTM }{Analysis Datetime}
\item{ ADT }{Analysis Date}
\item{ ADY }{Analysis Relative Day}
\item{ ATMF }{Analysis Time Imputation Flag}
\item{ AVISIT }{Analysis Visit}
\item{ AVISITN }{Analysis Visit (N)}
\item{ ATPT }{Analysis Timepoint}
\item{ APHASE }{Phase}
\item{ APHASEN }{Phase (N)}
\item{ APERIOD }{Period}
\item{ APERIODC }{Period (C)}
\item{ FANLDTM }{First Datetime of Dose for Analyte}
\item{ FANLDT }{First Date of Dose for Analyte}
\item{ FANLTM }{First Time of Dose for Analyte}
\item{ FANLTMF }{First Time of Dose for Analyte ImputeFL}
\item{ NFRLT }{Nom. Rel. Time from Analyte First Dose}
\item{ AFRLT }{Act. Rel. Time from Analyte First Dose}
\item{ FRLTU }{Rel. Time from First Dose Unit}
\item{ ABLFL }{Baseline Record Flag}
\item{ ADABLPFL }{Baseline ADA Eval. Param-Level Flag}
\item{ ADPBLPFL }{Post-Baseline ADA Eval. Param-Level Flag}
\item{ ADAFL }{ADA Population Flag}
}
}
\source{
Generated from admiral package (template ad_adab.R).
}
\usage{
adab
}
\description{
Anti-Drug Antibody Analysis Dataset
}
\details{
Contains a set of 22 unique Parameter Codes and Parameters: \tabular{ll}{
\strong{PARAMCD} \tab \strong{PARAM} \cr
ADADUR1  \tab ADA Duration (Weeks), Anti-XANOMELINE Antibody (1)                          \cr
ADASTAT1 \tab ADA Status of a patient, Anti-XANOMELINE Antibody (1)                       \cr
ADASTTV1 \tab ADA Status of a patient by Visit, Anti-XANOMELINE Antibody (1)              \cr
BABXANOM \tab Anti-XANOMELINE Antibody, Titer Units (1)                                   \cr
BFLAG1   \tab Baseline Pos/Neg, Anti-XANOMELINE Antibody (1)                              \cr
EMERNEG1 \tab Treatment Emergent - Negative, Anti-XANOMELINE Antibody (1)                 \cr
EMERPOS1 \tab Treatment Emergent - Positive, Anti-XANOMELINE Antibody (1)                 \cr
ENHANC1  \tab Treatment enhanced ADA, Anti-XANOMELINE Antibody (1)                        \cr
FPPDTM1  \tab First Post Dose Positive Datetime, Anti-XANOMELINE Antibody (1)             \cr
INDUCD1  \tab Treatment induced ADA, Anti-XANOMELINE Antibody (1)                         \cr
LPPDTM1  \tab Last Post Dose Positive Datetime, Anti-XANOMELINE Antibody (1)              \cr
NABSTAT1 \tab Nab Status, Anti-XANOMELINE Neutralizing Antibody (1)                       \cr
NABXANOM \tab Anti-XANOMELINE Neutralizing Antibody (1)                                   \cr
NOTRREL1 \tab No treatment related ADA, Anti-XANOMELINE Antibody (1)                      \cr
PBFLAGV1 \tab Post Baseline Pos/Neg by Visit, Anti-XANOMELINE Antibody (1)                \cr
PERSADA1 \tab Persistent ADA, Anti-XANOMELINE Antibody (1)                                \cr
RESULT1  \tab ADA interpreted per sample result, Anti-XANOMELINE Antibody (1)             \cr
RESULT2  \tab Nab interpreted per sample result, Anti-XANOMELINE Neutralizing Antibody (2)\cr
TFLAGV1  \tab Treatment related ADA by Visit, Anti-XANOMELINE Antibody (1)                \cr
TIMADA1  \tab Time to onset of ADA (Weeks), Anti-XANOMELINE Antibody (1)                  \cr
TRANADA1 \tab Transient ADA, Anti-XANOMELINE Antibody (1)                                 \cr
TRUNAFF1 \tab Treatment unaffected, Anti-XANOMELINE Antibody (1)
}
}
\examples{
data("adab")
}
\references{
None
}
\keyword{dataset}
\keyword{generic}
