% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguCorrValidator.R
\name{pgu.corrValidator}
\alias{pgu.corrValidator}
\title{pgu.corrValidator}
\format{
[R6::R6Class] object.
}
\description{
An R6 class that performs pairwise correlation of the features of the original and the imputed data set.
The correlation results of both data sets are compared by subtraction.
}
\section{Construction}{

x <- pguIMP::pgu.corrValidator$new()
}

\examples{
require(dplyr)
require(tibble)
data(iris)
data_df <- iris \%>\%
  tibble::as_tibble()
comp_df <- data_df \%>\%
  dplyr::mutate(Sepal.Length = sample(Sepal.Length))
corr_obj = pguIMP::pgu.corrValidator$new()
corr_obj$fit(data_df, comp_df)
print(corr_obj)

}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{featureNames}}{Returns the instance variable featureNames.
(character)}

\item{\code{orgR_mat}}{Returns the instance variable orgR_mat.
(matrix)}

\item{\code{impR_mat}}{Returns the instance variable impR_mat.
(matrix)}

\item{\code{orgP_mat}}{Returns the instance variable orgP_mat.
(matrix)}

\item{\code{impP_mat}}{Returns the instance variable impP_mat.
(matrix)}

\item{\code{corr_df}}{Returns the instance variable corr_df.
(tibble::tibble)}

\item{\code{summary_df}}{Returns the instance variable summary_df.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pgu.corrValidator-new}{\code{pgu.corrValidator$new()}}
\item \href{#method-pgu.corrValidator-print}{\code{pgu.corrValidator$print()}}
\item \href{#method-pgu.corrValidator-reset}{\code{pgu.corrValidator$reset()}}
\item \href{#method-pgu.corrValidator-fit}{\code{pgu.corrValidator$fit()}}
\item \href{#method-pgu.corrValidator-correlationScatterPlot}{\code{pgu.corrValidator$correlationScatterPlot()}}
\item \href{#method-pgu.corrValidator-correlationBarPlot}{\code{pgu.corrValidator$correlationBarPlot()}}
\item \href{#method-pgu.corrValidator-correlationBoxPlot}{\code{pgu.corrValidator$correlationBoxPlot()}}
\item \href{#method-pgu.corrValidator-correlationCompoundPlot}{\code{pgu.corrValidator$correlationCompoundPlot()}}
\item \href{#method-pgu.corrValidator-clone}{\code{pgu.corrValidator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.corrValidator-new"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.corrValidator-new}{}}}
\subsection{Method \code{new()}}{
Clears the heap and
indicates if instance of `pgu.corrValidator` is removed from heap.


Summary of the correlation deviation distribution.


Creates a square matrix which dimension corresponds to the length
of the instance variable featureNames. The matrix entries are set to a distinct `value`.


Flattens the results transforms them into a dataframe
and stores it into the instance variable corr_df.


Creates and returns a new `pgu.corrValidator` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$new(org_df = "tbl_df", imp_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{org_df}}{The original data to be analyzed.
(tibble::tibble)}

\item{\code{imp_df}}{The imputed version of the org_df data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `pgu.corrValidator` object.
(pguIMP::pgu.corrValidator)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.corrValidator-print"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.corrValidator-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a `pgu.corrValidator` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.corrValidator-reset"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.corrValidator-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the object `pgu.corrValidator` based on the instance variable featureNames..
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.corrValidator-fit"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.corrValidator-fit}{}}}
\subsection{Method \code{fit()}}{
Runs the corraltion analysis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$fit(org_df = "tbl_df", imp_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{org_df}}{Adataframe comprising the original data.
(tibble::tibble)}

\item{\code{imp_df}}{Adataframe comprising the imputed data.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.corrValidator-correlationScatterPlot"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.corrValidator-correlationScatterPlot}{}}}
\subsection{Method \code{correlationScatterPlot()}}{
Plots the correlation analysis results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$correlationScatterPlot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.corrValidator-correlationBarPlot"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.corrValidator-correlationBarPlot}{}}}
\subsection{Method \code{correlationBarPlot()}}{
Creates and returns a histogram from the cor_delat values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$correlationBarPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Bar plot
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.corrValidator-correlationBoxPlot"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.corrValidator-correlationBoxPlot}{}}}
\subsection{Method \code{correlationBoxPlot()}}{
Plots the correlation analysis results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$correlationBoxPlot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.corrValidator-correlationCompoundPlot"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.corrValidator-correlationCompoundPlot}{}}}
\subsection{Method \code{correlationCompoundPlot()}}{
Creates and returns a compund graphical analysis of the cor_delta values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$correlationCompoundPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Compound plot
(gridExtra::grid.arrange)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.corrValidator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.corrValidator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
