% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_derived.R
\name{EmptyLine}
\alias{EmptyLine}
\alias{Spacer}
\alias{MaybeEmpty}
\title{Recognize empty lines}
\usage{
EmptyLine()

Spacer()

MaybeEmpty()
}
\value{
A parser.
}
\description{
An empty line is a line that consists entirely of space-like characters.
\code{EmptyLine} is a parser that recognizes one empty line, \code{Spacer} recognizes
one or more empty lines and \code{MaybeEmpty} recognizes zero or more empty
lines. \code{EmptyLine} returns the empty line but \code{Spacer} and \code{MaybeEmpty}
discard these.
}
\section{Pseudocode}{


\preformatted{
space_like_eraser(x):
    d = x in which all "\\\\s+" are replaced by ""
    if d=="" TRUE else FALSE

Emptyline: satisfy(space_like_eraser)

Spacer: one_or_more(EmptyLine()) \%ret\% null

MaybeEmpty: zero_or_more(EmptyLine()) \%ret\% null
}

where \code{null} is the empty vector.
}

\examples{
EmptyLine()(" \t  ") # success
EmptyLine()("    .") # failure
EmptyLine()("") # success
Spacer()(c("   \t  ", "    ", "abc"))
Spacer()(c("            ", "    ", "Important text"))
Spacer()(c("Important text")) # failure, missing empty line
MaybeEmpty()(c("            ", "    ", "Important text")) # success, just as Spacer()
MaybeEmpty()(c("Important text")) # success, in contrast to Spacer()
}
