% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkrt-list.R
\name{pkrt_list}
\alias{pkrt_list}
\title{Cite a collection of R packages}
\usage{
pkrt_list(...)
}
\arguments{
\item{...}{Character vectors, separated by commas, of packages to cite.}
}
\value{
A list of package citations with S3 class \code{pkrt_list}.
}
\description{
Creates a list of package citations that can be turned into a
character string or data frame. This function should normally only be used
in an R Markdown or Quarto document, in which case \code{pkrt_list()}
automatically references the cited packages in the first (by default)
\code{.bib} file specified in the YAML header if no references of the packages
already exist.
}
\details{
This function automatically discards duplicate and base packages. You can use
\code{pkrt_list()} in combination with \code{\link[renv:dependencies]{renv::dependencies()}} to cite all the
packages used in a project or directory.
}
\examples{
# Create a list of citations
citations <- pkrt_list("pakret", "readr", "knitr")

# You can then turn the citations into a character string
paste(citations, collapse = ", ")

# Or a data frame
as.data.frame(citations)
}
