% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{plot_convergence}
\alias{plot_convergence}
\title{Plot moving average}
\usage{
plot_convergence(
  df,
  param,
  block_size = 500,
  conv_limit = 0,
  y_min = NULL,
  y_max = NULL,
  breaks = NULL,
  variance = FALSE
)
}
\arguments{
\item{df}{a dataframe.}

\item{param}{character string. Name of variable of the dataframe for which to plot the moving average.}

\item{block_size}{numeric. Define the size of the blocks at which the mean of the variable (`param`) has to be defined and plotted. Default is 500 iterations.}

\item{conv_limit}{numeric. Define the convergence limit, under which the relative change between block of iterations should lie.}

\item{y_min}{numeric. Define the minimum value of the parameter to display on th y-axis of the convergence plot.If NULL (default, not defined), this will automatically be set near the minimum value of `param`.}

\item{y_max}{numeric. Define the maximum value of the parameter to display on th y-axis of the convergence plot. If NULL (default, not defined), this will automatically be set near the maximum value of `param`.}

\item{breaks}{numeric. Number of iterations at which the breaks should be placed on the plot. Default is NULL, hence a tenth of the length of the vector `param` is used.}

\item{variance}{logical. Determine whether the variance of the vector should be plotted instead of the mean. Default is FALSE.}
}
\value{
A ggplot graph.
}
\description{
This function plots the moving average of a user-defined variable.
}
\examples{
# Checking the moving average of the incremental QALYs using the example data.
data(df_pa)
plot_convergence(df = df_pa,
                 param = "inc_qaly"
                 )
}
