% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_hemodel.R
\name{generate_pa_inputs_psm}
\alias{generate_pa_inputs_psm}
\title{Generate probabilistic model inputs for partitioned survival model.}
\usage{
generate_pa_inputs_psm(n_sim = 10000, sd_var = 0.2, seed_num = 452)
}
\arguments{
\item{n_sim}{integer. Number of probabilistic value to draw for each model input. Default is 10,000.}

\item{sd_var}{numeric. Determines the standard error of the mean to use for the normal distributions when the standard error not known. Default is 0.2 (20\%).}

\item{seed_num}{integer. The seed number to use when drawing the probabilistic values. Default is 452.}
}
\value{
A dataframe. A description of the variables of the returned dataframe is available in the documentation of the \code{\link{df_pa_psm}} dataframe.
}
\description{
This function generates the probabilistic model inputs for the example health economic model developed to test the functionalities of the package.
}
\examples{
# Generating probabilistic model inputs and storing them in an object.
\donttest{
df_inputs_prob <- generate_pa_inputs_psm(n_sim = 10)
}
}
