% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glean_vd.R
\name{glean_vd}
\alias{glean_vd}
\title{Parse data from requests to VecDyn}
\usage{
glean_vd(res, cols = NULL, returnunique = FALSE)
}
\arguments{
\item{res}{a list of responses from VecDyn as an \code{ohvbd.responses} object.}

\item{cols}{a character vector of columns to extract from the dataset. If specified, this will be adjusted to always include the "dataset_id" column.}

\item{returnunique}{whether to return only the unique rows within each dataset according to the filtered columns.}
}
\value{
An \code{ohvbd.data.frame} containing the requested data.
}
\description{
Extract the data returned by a call to \code{\link[=fetch_vd]{fetch_vd()}}, filter columns of interest, and find unique rows if required.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_vd(247) |>
  glean_vd(cols=c("species",
                    "sample_start_date",
                    "sample_value"),
             returnunique=TRUE)

ohvbd.ids(247, "vd") |>
  fetch() |>
  glean() # Calls glean_vd()
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{vecdyn}
