# PARSE RESULTS
#' @include AllGenerics.R
NULL

#' @method as.data.frame HALSearch
#' @rdname as.data.frame
#' @export
as.data.frame.HALSearch <- function(x, ...) {
  if (length(x$facet_counts) > 0) {
    ## Faceting?
    facets <- x$facet_counts
    res <- parse_facets(facets)
  } else if (length(x$grouped) > 0) {
    ## Grouped?
    groups <- x$grouped
    res <- lapply(X = groups, FUN = parse_groups)
    if (length(res) == 1) res <- res[[1L]]
  } else {
    docs <- x$response$docs
    res <- parse_documents(docs)
  }
  res
}

parse_facets <- function(x) {
  if (length(x$facet_fields) > 0) {
    res <- lapply(X = x$facet_fields, FUN = parse_facets_field)
  }
  if (length(x$facet_pivot) > 0) {
    warning("Cannot simplify pivot (decision tree) faceting.", call. = FALSE)
    return(x$facet_pivot)
  }
  if (length(x$facet_ranges) > 0) {
    res <- lapply(X = x$facet_ranges, FUN = parse_facets_range)
  }
  res
}
parse_facets_field <- function(x) {
  data.frame(
    .value = I(unlist(x[seq(1, length(x), by = 2)], recursive = FALSE)),
    .counts = unlist(x[seq(2, length(x), by = 2)], recursive = FALSE),
    row.names = NULL
  )
}
parse_facets_range <- function(x) {
  x <- x$counts
  data.frame(
    .value = I(unlist(x[seq(1, length(x), by = 2)], recursive = FALSE)),
    .counts = unlist(x[seq(2, length(x), by = 2)], recursive = FALSE),
    row.names = NULL
  )
}

parse_groups <- function(x) {
  val <- lapply(
    X = x$groups,
    FUN = function(x) {
      docs <- rapply(object = x$doclist$docs, f = I, how = "replace")
      docs <- lapply(X = docs, FUN = function(x) as.data.frame(rbind(x)))
      do.call(rbind.data.frame, docs)
    }
  )

  n <- vapply(X = val, FUN = nrow, FUN.VALUE = integer(1))
  grp <- vapply(
    X = x$groups,
    FUN = function(x) { x$groupValue %||% "" },
    FUN.VALUE = character(1)
  )
  grp <- rep(grp, n)

  val <- do.call(rbind.data.frame, val)
  data.frame(.group = grp, val, row.names = NULL)
}

parse_documents <- function(x) {
  docs <- rapply(object = x, f = I, how = "replace")
  docs <- lapply(X = docs, FUN = function(x) as.data.frame(rbind(x)))
  docs <- do.call(rbind, docs)
  rownames(docs) <- NULL
  docs
}
