% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_images.R
\name{compare_image_dirs}
\alias{compare_image_dirs}
\title{Compare Images in Two Directories}
\usage{
compare_image_dirs(
  baseline_dir,
  current_dir,
  pattern = "\\\\.(png|jpe?g|webp|tiff?)$",
  recursive = FALSE,
  diff_dir = NULL,
  parallel = FALSE,
  ...
)
}
\arguments{
\item{baseline_dir}{Path to the directory containing baseline images.}

\item{current_dir}{Path to the directory containing current images to
compare against baseline.}

\item{pattern}{Regular expression pattern to match image files. Default
matches common image formats (PNG, JPEG, WEBP, TIFF).}

\item{recursive}{Logical; if \code{TRUE}, search subdirectories recursively.
Default is \code{FALSE}.}

\item{diff_dir}{Directory to save diff images. If \code{NULL}, no diff images
are created.}

\item{parallel}{Logical; if \code{TRUE}, compare images in parallel. See
\code{\link[=compare_images_batch]{compare_images_batch()}} for details.}

\item{...}{Additional arguments passed to \code{\link[=compare_images_batch]{compare_images_batch()}}.}
}
\value{
A tibble (if available) or data.frame with one row per comparison,
containing all columns from \code{\link[=compare_images]{compare_images()}} plus a \code{pair_id} column.
}
\description{
Compare all images in a baseline directory against corresponding images in a
current directory. Files are matched by relative path (including
subdirectories when \code{recursive = TRUE}).
}
\details{
The baseline directory is the source of truth. For each image found in
\code{baseline_dir} matching \code{pattern}:
\itemize{
\item If a corresponding file exists in \code{current_dir} (same relative
path), it is included in the comparison.
\item If the file is missing from \code{current_dir}, a warning is issued and
the file is excluded from results.
}

Files that exist only in \code{current_dir} (not in \code{baseline_dir}) are not
compared, but a message is emitted noting how many such files were found.
}
\examples{
\dontrun{
# Compare all images in two directories
results <- compare_image_dirs("baseline/", "current/")

# Only compare PNG files
results <- compare_image_dirs("baseline/", "current/", pattern = "\\\\.png$")

# Include subdirectories and save diff images
results <- compare_image_dirs(
  "baseline/",
  "current/",
  recursive = TRUE,
  diff_dir = "diffs/"
)

# Check which comparisons failed
results[!results$match, ]
}
}
\seealso{
\code{\link[=compare_images_batch]{compare_images_batch()}} for comparing explicit pairs,
\code{\link[=compare_images]{compare_images()}} for single comparisons.
}
