% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/group.R
\docType{methods}
\name{group_names}
\alias{group_names}
\alias{group_names-method}
\alias{group_levels}
\alias{group_levels-method}
\alias{group_factor}
\alias{group_factor-method}
\alias{group_rows}
\alias{group_rows-method}
\alias{group_n}
\alias{group_n-method}
\alias{group_size}
\alias{group_size-method}
\alias{group_indices}
\alias{group_indices-method}
\alias{group_levels,ReferenceGroups-method}
\alias{group_names,ReferenceGroups-method}
\alias{group_factor,ReferenceGroups-method}
\alias{group_indices,ReferenceGroups-method}
\alias{group_rows,ReferenceGroups-method}
\alias{group_n,ReferenceGroups-method}
\alias{group_size,ReferenceGroups-method}
\title{Grouping Metadata}
\usage{
group_names(object)

group_levels(object)

group_factor(object, ...)

group_rows(object)

group_n(object)

group_size(object)

group_indices(object)

\S4method{group_levels}{ReferenceGroups}(object)

\S4method{group_names}{ReferenceGroups}(object)

\S4method{group_factor}{ReferenceGroups}(object, exclude = NA)

\S4method{group_indices}{ReferenceGroups}(object)

\S4method{group_rows}{ReferenceGroups}(object)

\S4method{group_n}{ReferenceGroups}(object)

\S4method{group_size}{ReferenceGroups}(object)
}
\arguments{
\item{object}{A \link[=group]{grouped} \R object.}

\item{...}{Currently not used.}

\item{exclude}{A \code{\link{character}} vector of values to be excluded when forming
the set of levels.}
}
\value{
\itemize{
\item \code{group_levels()} returns a \code{\link{character}} vector giving the group
names.
\item \code{group_size()} returns an \code{\link{integer}} vector giving the size of each
group.
\item \code{group_n()} gives the total number of groups.
\item \code{group_names()} returns a \code{\link{character}} vector giving the name of
the group that each observation belongs to.
\item \code{group_factor()} returns a \code{\link{factor}} vector giving the name of
the group that each observation belongs to.
\item \code{group_indices()} returns an \code{\link{integer}} vector giving the group
that each value belongs to.
\item \code{group_rows()} returns a \code{list} of \code{\link{integer}} vectors giving the
observation that each group contains.
}
}
\description{
Retrieve the (reference) groups to which the observations belong.
}
\examples{
## Data from Aitchison 1986
data("slides")

## Coerce to compositional data
coda <- as_composition(slides, groups = 2)

## Grouping metadata
group_levels(coda)

group_names(coda)

group_indices(coda)

group_rows(coda)

group_n(coda)

group_size(coda)
}
\seealso{
Other grouping methods: 
\code{\link{group}()},
\code{\link{group_split}()},
\code{\link{group_subset}()},
\code{\link{is_assigned}()}
}
\author{
N. Frerebeau
}
\concept{grouping methods}
