% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_like.R, R/filebacked_neurovec.R,
%   R/mapped_neurovec.R, R/neurohypervec.R, R/neurovecseq.R, R/neurovol.R,
%   R/sparse_neurovec.R
\name{linear_access,DenseNeuroVol,numeric-method}
\alias{linear_access,DenseNeuroVol,numeric-method}
\alias{linear_access,DenseNeuroVec,numeric-method}
\alias{linear_access,DenseNeuroVol,integer-method}
\alias{linear_access,DenseNeuroVec,integer-method}
\alias{linear_access,FileBackedNeuroVec,numeric-method}
\alias{linear_access,MappedNeuroVec,numeric-method}
\alias{linear_access,NeuroHyperVec,ANY-method}
\alias{linear_access,NeuroVecSeq,numeric-method}
\alias{linear_access,SparseNeuroVol,numeric-method}
\alias{linear_access,AbstractSparseNeuroVec,numeric-method}
\title{Linear Access Method for FileBackedNeuroVec}
\usage{
\S4method{linear_access}{DenseNeuroVol,numeric}(x, i)

\S4method{linear_access}{DenseNeuroVec,numeric}(x, i)

\S4method{linear_access}{DenseNeuroVol,integer}(x, i)

\S4method{linear_access}{DenseNeuroVec,integer}(x, i)

\S4method{linear_access}{FileBackedNeuroVec,numeric}(x, i)

\S4method{linear_access}{MappedNeuroVec,numeric}(x, i)

\S4method{linear_access}{NeuroHyperVec,ANY}(x, i, ...)

\S4method{linear_access}{NeuroVecSeq,numeric}(x, i)

\S4method{linear_access}{SparseNeuroVol,numeric}(x, i)

\S4method{linear_access}{AbstractSparseNeuroVec,numeric}(x, i)
}
\arguments{
\item{x}{A NeuroVecSeq object}

\item{i}{Numeric vector of indices for linear access}

\item{...}{Additional arguments (not used)}
}
\value{
Numeric vector of accessed values
}
\description{
Internal method providing linear access to memory-mapped data.

Provides linear access to the data across all vectors in the sequence.
}
\examples{
\donttest{
# Create a small NeuroVec and save it
nvec <- NeuroVec(matrix(1:32, 8, 4), NeuroSpace(c(2,2,2,4)))
tmp <- tempfile(fileext = ".nii")
write_vec(nvec, tmp)

# Load as FileBackedNeuroVec and access values
fbvec <- FileBackedNeuroVec(tmp)
values <- linear_access(fbvec, 1:10)

# Clean up
unlink(tmp)
}

}
