% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{nday}
\alias{nday}
\title{neat alias of the week day with reference based on current date}
\usage{
nday(date, show_relative_day = FALSE, reference_alias = NULL)
}
\arguments{
\item{date}{a Date or POSIX time stamp}

\item{show_relative_day}{a Boolean. If set to TRUE, a reference alias of week
day is shown based on current date such as
Today/Yesterday/Tomorrow/Last/Coming.}

\item{reference_alias}{Deprecated. Use 'show_relative_day' instead.}
}
\value{
week day of the date in a readable format with reference alias based
on current date
}
\description{
neat alias of the week day with reference based on current date
}
\examples{
# Get day of the week of current date without reference alias
x <- Sys.Date()
nday(x, show_relative_day = FALSE)
# Get day of the week with reference alias
nday(x, show_relative_day = TRUE)
}
