% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_optimize_controls_inputs.R
\name{process_qs}
\alias{process_qs}
\title{Process the desired sample sizes for \code{\link{optimize_controls}()}}
\usage{
process_qs(ratio, q_s, n_s, treated, k, group, st_vals, stratios)
}
\arguments{
\item{ratio}{a numeric or vector specifying the desired ratio of controls to `treated` in
each stratum. If there is one control group and all treated units should be included,
this can be a numeric. Otherwise, this should be
a vector with one entry per treatment group, in the same order as the levels of
\code{z}, including the treated level. If \code{NULL}, \code{q_s} should be specified.}

\item{q_s}{a named vector or matrix indicating how many units are to be selected from each stratum.
If there is one control group and all treated units are desired, this can be a vector; otherwise,
this should have one row per treatment group, where the order of the rows matches the order of
the levels of \code{z}, including the treated level.
If \code{NULL}, \code{ratio} should be specified. If both are specified, \code{q_s} will take priority.
Typically, if the desired ratio is not feasible for every stratum, \code{q_s} should be generated
using \code{\link{generate_qs}()}.}

\item{treated}{which treatment value should be considered the treated units. This
must be one of the values of \code{z}.}
}
\value{
A matrix of sample sizes for each treatment and stratum.
}
\description{
Processes the inputs to \code{\link{optimize_controls}()} to formulate sample size constraints.
}
\keyword{internal}
