% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiclass_learners.R
\name{lnr_multinomial_vglm}
\alias{lnr_multinomial_vglm}
\title{\code{VGAM::vglm} Multinomial Learner}
\usage{
lnr_multinomial_vglm(data, formula, ...)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{...}{Any extra arguments that should be passed to the internal model
for model fitting purposes.}
}
\value{
A prediction function that accepts \code{newdata},
which returns predictions (a numeric vector of density prediction values at the
outcome value observed in the \code{newdata} conditioning on the predictor
variables in \code{newdata}).
}
\description{
\code{VGAM::vglm} Multinomial Learner
}
\examples{
df <- mtcars
df$cyl <- as.factor(df$cyl)
lnr_multinomial_vglm(df, cyl ~ hp + mpg)(df)
lnr_multinomial_vglm(iris, Species ~ .)(iris)
}
