% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-special.R
\name{psigamma}
\alias{psigamma}
\alias{psigamma,numeric-method}
\alias{psigamma,dualr-method}
\title{Polygamma function for dual numbers}
\usage{
psigamma(x, deriv = 0L)

\S4method{psigamma}{numeric}(x, deriv = 0L)

\S4method{psigamma}{dualr}(x, deriv = 0L)
}
\arguments{
\item{x}{A numeric or dual value.}

\item{deriv}{Integer derivative order (0 = digamma, 1 = trigamma, etc.).}
}
\value{
The polygamma function value.
}
\description{
Computes \eqn{\psi^{(n)}(x)} where \eqn{n} is the derivative order.
The derivative of \eqn{\psi^{(n)}(x)} is \eqn{\psi^{(n+1)}(x)}.
}
\examples{
psigamma(1, deriv = 0)
x <- dual_variable(2)
value(psigamma(x, deriv = 1))
}
