% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-arithmetic.R
\name{dual-summary}
\alias{dual-summary}
\alias{Summary,dualr-method}
\title{Summary group generic for dual numbers}
\usage{
\S4method{Summary}{dualr}(x, ..., na.rm = FALSE)
}
\arguments{
\item{x}{A dual number.}

\item{...}{Additional dual or numeric values.}

\item{na.rm}{Logical; ignored (present for generic compatibility).}
}
\value{
A \code{dual} for sum/prod/min/max; a \code{dual_vector} for range;
logical for any/all.
}
\description{
Implements \code{sum}, \code{prod}, \code{min}, \code{max}, \code{range},
\code{any}, and \code{all} for dual numbers. Derivatives are propagated
correctly through \code{sum} (additive) and \code{prod} (multiplicative).
}
\examples{
x <- dual_variable(2)
y <- dual_variable(5)
value(sum(x, y))
value(prod(x, y))

}
