% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFinalSizeDistEscape.R
\name{getFinalSizeDistEscape}
\alias{getFinalSizeDistEscape}
\title{Estimate the distribution of final outbreak sizes by group using a hybrid model: stochastic simulations
for smaller-sized outbreaks and deterministic ordinary differential equation model for "escaped" outbreaks}
\usage{
getFinalSizeDistEscape(
  n,
  transmrates,
  recoveryrate,
  popsize,
  initR,
  initI,
  initV
)
}
\arguments{
\item{n}{the number of simulations to run}

\item{transmrates}{matrix of group-to-group (column-to-row) transmission rates}

\item{recoveryrate}{inverse of mean infectious period}

\item{popsize}{the population size of each group}

\item{initR}{initial number of each group already infected and removed (included in size result)}

\item{initI}{initial number of each group infectious}

\item{initV}{initial number of each group vaccinated}
}
\value{
a matrix with the final number infected from each group (column) in each simulation (row)
}
\description{
Estimate the distribution of final outbreak sizes by group using a hybrid model: stochastic simulations
for smaller-sized outbreaks and deterministic ordinary differential equation model for "escaped" outbreaks
}
\examples{
getFinalSizeDistEscape(n = 10, transmrates = matrix(0.2, 2 ,2), recoveryrate = 0.3,
popsize = c(100, 150), initR = c(0, 0), initI = c(0, 1), initV = c(10, 10))
}
