% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_sdreport}
\alias{get_sdreport}
\title{Calculate standard errors}
\usage{
get_sdreport(obj, getReportCovariance = FALSE, silent = FALSE, ...)
}
\arguments{
\item{obj}{The list returned by \code{\link[RTMB:TMB-interface]{RTMB::MakeADFun()}}}

\item{getReportCovariance}{Logical, passed to \code{\link[RTMB:TMB-interface]{RTMB::sdreport()}}}

\item{silent}{Logical, whether to report progress to console. See details.}

\item{...}{Other arguments to \code{\link[RTMB:TMB-interface]{RTMB::sdreport()}} besides \verb{par.fixed, hessian.fixed, getReportCovariance}}
}
\value{
Object returned by \code{\link[RTMB:TMB-interface]{RTMB::sdreport()}}. A correlation matrix is generated and stored in: \code{get_sdreport(obj)$env$corr.fixed}
}
\description{
A wrapper function to return standard errors. Various numerical techniques are employed to obtain
a positive-definite covariance matrix.
}
\details{
In marginal cases where the determinant of the Hessian matrix is less than 0.1, several steps are utilized to
obtain a positive-definite covariance matrix, in the following order:
\enumerate{
\item Invert hessian returned by \code{h <- obj@he(obj$env.last.par.best)} (skipped in models with random effects)
\item Invert hessian returned by \code{h <- stats::optimHess(obj$env.last.par.best, obj$fn, obj$gr)}
\item Invert hessian returned by \code{h <- numDeriv::jacobian(obj$gr, obj$env.last.par.best)}
\item Calculate covariance matrix from \code{chol2inv(chol(h))}
}
}
