% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_CV_density.R
\name{plot_CV_density}
\alias{plot_CV_density}
\title{Density plot}
\usage{
plot_CV_density(
  input_list,
  xaxes_limit = 50,
  cv_col = c("RT", "Pep_quant", "PG_quant")
)
}
\arguments{
\item{input_list}{A list with data frames and respective information on quantitative or retention time precision.}

\item{xaxes_limit}{Numeric. Limit of x-axes in plot.}

\item{cv_col}{Character string. Choose between "RT", "Pep_quant", "PG_quant" for corresponding precision category. Default is  RT for retention time precision. Pep_quant equals quantitative precision on peptide-level. PG_quant equals quantitative precision on proteingroup-level.}
}
\value{
This function returns a density plot.
}
\description{
Plot cumulative density for precision results
}
\details{
Quantitative or retention time precision are plotted as cumulative density.
}
\examples{
# Load libraries
library(dplyr)
library(comprehenr)
library(tibble)

# Example data
set.seed(123)
data <- list(
  "A" = tibble::tibble(
    Analysis_mpwR = rep("A", times = 10),
    CV_Retention.time_mpwR = sample(1:20, 10),
    CV_Peptide_LFQ_mpwR = sample(1:30, 10),
    CV_ProteinGroup_LFQ_mpwR = sample(1:30, 10)),
 "B" = tibble::tibble(
     Analysis_mpwR = rep("B", times = 10),
     CV_Retention.time_mpwR = sample(1:20, 10),
     CV_Peptide_LFQ_mpwR = sample(1:30, 10),
     CV_ProteinGroup_LFQ_mpwR = sample(1:30, 10))
)

# Plot
plot_CV_density(
  input_list = data,
  cv_col = "Pep_quant"
)
}
\author{
Oliver Kardell
}
