% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Slope3d.R
\name{Slope3d}
\alias{Slope3d}
\title{Plot results of a Slope analysis of a surface (HTML widget)}
\usage{
Slope3d(
  Slope_File,
  colors = c("blue", "cornflowerblue", "green", "yellowgreen", "yellow", "orangered",
    "red"),
  maskNegatives = TRUE,
  legend = TRUE,
  main = "",
  cex = 1,
  widget_size_px = 768,
  scene_zoom = 1.5,
  leftOffset = 0,
  fieldofview = 0,
  title_font_size_px = 30,
  legend_magnify = 1,
  fileName = NA,
  binary = FALSE
)
}
\arguments{
\item{Slope_File}{An object that stores the output of the Slope function}

\item{colors}{Character vector of colors to build a continuous color gradient}

\item{maskNegatives}{Logical; if TRUE, negative slopes are masked in black.
If FALSE, negatives are reflected into the positive range (original behavior).}

\item{legend}{Logical; draw a legend (right side of the widget)}

\item{main}{Plot title}

\item{cex}{Base scaling for legend/ticks (relative multiplier)}

\item{widget_size_px}{Square widget size in pixels (default 768)}

\item{scene_zoom}{Initial zoom for the 3d scene (default 1.5)}

\item{leftOffset}{Horizontal camera nudge (-1..1 recommended)}

\item{fieldofview}{Field of view in degrees (0 = isometric)}

\item{title_font_size_px}{Title font size in pixels (default 30)}

\item{legend_magnify}{Additional scale factor for the legend/tick text}

\item{fileName}{Optional file base name to save a colored *.ply (no legend)}

\item{binary}{Binary PLY if TRUE (smaller files)}
}
\description{
A function that produces a three-dimensional HTML-based rendering of surface slope.
The \code{Slope()} function must be performed prior to using \code{Slope3d()}.
}
\details{
Colors represent face slope magnitudes. With \code{maskNegatives = TRUE}, negative
slopes are shown in black. With \code{maskNegatives = FALSE}, negative magnitudes
are reflected into the positive range for coloring continuity (original behavior).

The plotting window is an HTML widget (no Quartz/rgl window). The legend is
rendered in HTML/CSS and aligned vertically at the right of the scene.
}
\examples{
s <- Slope(Tooth)
if(interactive()){Slope3d(s)}
}
