% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_arguments.R
\name{check_arguments}
\alias{check_arguments}
\title{Check that tidying methods use allowed argument names}
\usage{
check_arguments(tidy_method, strict = TRUE)
}
\arguments{
\item{tidy_method}{A tidying method. For example: \code{glance.Arima}.}

\item{strict}{Logical indicating whether the strict version of tests should be used. Defaults
to \code{TRUE}.}
}
\value{
An invisible \code{NULL}. This function should be called for side effects, not return values.
}
\description{
Call this function to perform tests. If a tests fails, an informative error
will be thrown. Otherwise silent.

Tests when \code{strict = FALSE}:
\itemize{
\item None
}

Tests when \code{strict = TRUE}:
\itemize{
\item \code{tidy_method} has a \code{conf.int} argument if it has a \code{conf.level} argument.
\item \code{tidy_method} has a \code{conf.level} argument if it has a \code{conf.int} argument.
\item \code{conf.int} defaults to \code{FALSE} when present.
\item \code{conf.level} defaults to `0.95`` when present.
\item \code{exponentiate} defaults to \code{FALSE} when present.
\item All arguments to \code{tidy_method} are listed in the \link{argument_glossary}.
}
}
\seealso{
\code{\link[testthat:logical-expectations]{testthat::expect_true()}}
}
