% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{gdataset.unload}
\alias{gdataset.unload}
\title{Unload a dataset from the namespace}
\usage{
gdataset.unload(path, validate = FALSE)
}
\arguments{
\item{path}{Path to a previously loaded dataset}

\item{validate}{If TRUE, error if path is not currently loaded; otherwise silently no-op}
}
\value{
Invisible NULL
}
\description{
Removes all tracks and intervals from a previously loaded dataset.
If a track was shadowing another, the shadowed track becomes visible again.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

dataset_path <- gdataset.example_path()
gdataset.load(dataset_path)
gdataset.unload(dataset_path, validate = TRUE)

}
\seealso{
\code{\link{gdataset.load}}, \code{\link{gdataset.ls}}
}
