% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_ns.R
\name{mc_ns}
\alias{mc_ns}
\title{Non-structured Covariance Model}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression Models in R:
The mcglm Package. Journal of Statistical Software, 84(4), 1--30.
}
\usage{
mc_ns(id, data, group = NULL, marca = NULL)
}
\arguments{
\item{id}{A character string giving the name of the column in
\code{data} that identifies the observational units (e.g., subjects).
Each unit must have the same number of observations. For time series
or spatial data without replication, the same identifier should be
used for all observations.}

\item{data}{A \code{data.frame} containing the variables referenced by
\code{id} and, optionally, \code{group}.}

\item{group}{An optional character string giving the name of a column in
\code{data} that defines groups for which different covariance
structures may be specified. If \code{NULL}, a single non-structured
covariance model is used for all units.}

\item{marca}{An optional character string specifying the level of
\code{group} for which the non-structured covariance components are
excluded (i.e., set to zero). This allows selective activation of the
non-structured covariance according to group membership.}
}
\value{
A list of symmetric block-diagonal matrices, each representing one
covariance component of the non-structured matrix linear predictor.
The length of the list is equal to \eqn{n(n - 1) / 2}, where \eqn{n} is
the number of observations per unit. Each element of the list is a
sparse matrix of class \code{"dgCMatrix"} obtained by stacking unit-
specific covariance blocks along the diagonal. These matrices are used
internally to construct the dispersion linear predictor in
\code{mcglm}.
}
\description{
Constructs the components of the matrix linear predictor associated
with a fully non-structured covariance model in multivariate covariance
generalized linear models. This specification allows each pair of
observations within a unit to have its own covariance parameter,
resulting in a highly flexible but parameter-intensive model.

Due to the quadratic growth in the number of parameters, this structure
is typically suitable only for datasets with a small number of repeated
measurements per unit.
}
\details{
The function requires a balanced design, meaning that all units
identified by \code{id} must have the same number of observations.
An error is raised otherwise. When \code{group} and \code{marca} are
provided, covariance components are generated only for units not
belonging to the specified level \code{marca}; for those units, the
corresponding blocks are set to zero.
}
\seealso{
\code{mc_id}, \code{mc_dglm}, \code{mc_dist}, \code{mc_ma},
\code{mc_rw}, \code{mc_mixed}
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
