% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcc_equation.R
\name{mcc_equation}
\alias{mcc_equation}
\title{Calculate Mean Cumulative Count using the equation method}
\usage{
mcc_equation(
  data,
  id_var,
  time_var,
  cause_var,
  weights = NULL,
  adjust_times = TRUE,
  time_precision = 1e-06,
  include_details = TRUE
)
}
\arguments{
\item{data}{A data.frame or tibble containing the required variables}

\item{id_var}{Name of the column containing participant IDs (as string or symbol)}

\item{time_var}{Name of the column containing follow-up times (as string or symbol)}

\item{cause_var}{Name of the column containing event indicators (as string or symbol)
(1=event of interest, 2=competing risk, 0=censoring)}

\item{weights}{Name of the column containing weights (as string, optional)}

\item{adjust_times}{Whether to automatically adjust times for simultaneous events (default: TRUE)}

\item{time_precision}{Precision used for adjusting simultaneous events (default: 1e-6)}

\item{include_details}{Whether to include detailed calculation tables and intermediate
objects in the output (default: TRUE).}
}
\value{
A list containing MCC results. If \code{include_details = TRUE}, returns complete
calculation details. Otherwise, returns only the final MCC estimates.
}
\description{
Calculate Mean Cumulative Count using the equation method
}
\keyword{internal}
