/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool;

import choco.cp.solver.constraints.integer.bool.BooleanFactory;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class LargeNand
extends AbstractLargeIntSConstraint {
    private final IStateInt toONE;

    LargeNand(IntDomainVar[] vars, IEnvironment environment) {
        super(ConstraintEvent.LINEAR, vars);
        this.toONE = environment.makeInt(0);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    @Override
    public void propagate() throws ContradictionException {
        int toONE = 0;
        int lastIdx = 0;
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (((IntDomainVar[])this.vars)[i].isInstantiatedTo(0)) {
                this.setEntailed();
                return;
            }
            if (((IntDomainVar[])this.vars)[i].isInstantiatedTo(1)) {
                ++toONE;
                continue;
            }
            lastIdx = i;
        }
        if (toONE == ((IntDomainVar[])this.vars).length) {
            this.fail();
        } else if (toONE == ((IntDomainVar[])this.vars).length - 1) {
            ((IntDomainVar[])this.vars)[lastIdx].instantiate(0, this, false);
            this.setEntailed();
            return;
        }
        this.toONE.set(toONE);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        int val = ((IntDomainVar[])this.vars)[idx].getVal();
        switch (val) {
            case 0: {
                this.setEntailed();
                break;
            }
            case 1: {
                this.toONE.add(1);
                if (this.toONE.get() < ((IntDomainVar[])this.vars).length - 1) break;
                this.filter();
            }
        }
    }

    private void filter() throws ContradictionException {
        int n;
        int toONE = this.toONE.get();
        if (toONE == (n = ((IntDomainVar[])this.vars).length)) {
            this.fail();
        } else {
            for (int i = 0; i < n; ++i) {
                if (!((IntDomainVar[])this.vars)[i].isInstantiated()) {
                    ((IntDomainVar[])this.vars)[i].instantiate(0, this, false);
                    this.setEntailed();
                    break;
                }
                if (((IntDomainVar[])this.vars)[n - 1 - i].isInstantiated()) continue;
                ((IntDomainVar[])this.vars)[n - 1 - i].instantiate(0, this, false);
                this.setEntailed();
                break;
            }
        }
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        for (int i = 0; i < tuple.length; ++i) {
            if (tuple[i] != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean isEntailed() {
        int i;
        for (i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (!((IntDomainVar[])this.vars)[i].isInstantiatedTo(0)) continue;
            return Boolean.TRUE;
        }
        for (i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (!((IntDomainVar[])this.vars)[i].fastCanBeInstantiatedTo(0)) continue;
            return null;
        }
        return Boolean.FALSE;
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return BooleanFactory.and((IntDomainVar[])this.vars);
    }
}

