% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-functions.R
\name{test-functions}
\alias{test-functions}
\title{Test Functions for Optimization}
\description{
Collection of benchmark test functions for evaluating optimization algorithms.
These functions are commonly used in the literature to test the performance
of metaheuristic optimization algorithms.
}
\details{
The following test functions are implemented:

\bold{Unimodal Functions:}
\itemize{
  \item \bold{F01} - Sphere function: Simple quadratic function with a single minimum at the origin. \code{\link{F01}}
  \item \bold{F02} - Sum of absolute values and products: Combines sum and product of absolute values. \code{\link{F02}}
  \item \bold{F03} - Sum of squared terms: Sum of squared cumulative sums. \code{\link{F03}}
  \item \bold{F04} - Maximum absolute value: Returns the maximum absolute value in the vector. \code{\link{F04}}
  \item \bold{F05} - Rosenbrock function: Classic test function with a banana-shaped valley. \code{\link{F05}}
  \item \bold{F06} - Shifted sphere function: Sphere function shifted to (-0.5, -0.5, ...). \code{\link{F06}}
  \item \bold{F07} - Quartic function with noise: Quartic terms with added random noise. \code{\link{F07}}
}

\bold{Multimodal Functions:}
\itemize{
  \item \bold{F08} - Schwefel function: Multimodal function with many local minima. \code{\link{F08}}
  \item \bold{F09} - Rastrigin function: Many local minima arranged in a regular pattern. \code{\link{F09}}
  \item \bold{F10} - Ackley function: Global minimum at origin with many local minima. \code{\link{F10}}
  \item \bold{F11} - Griewank function: Many local minima regularly distributed. \code{\link{F11}}
  \item \bold{F12} - Penalized function 1: Complex landscape with penalty terms. \code{\link{F12}}
  \item \bold{F13} - Penalized function 2: Different penalty terms creating complex landscape. \code{\link{F13}}
  \item \bold{F14} - Shekel's Foxholes: 25 minima of different depths. \code{\link{F14}}
  \item \bold{F15} - Kowalik function: Multimodal function for testing optimization. \code{\link{F15}}
  \item \bold{F16} - Six-Hump Camel Back: Six local minima, two global. \code{\link{F16}}
  \item \bold{F17} - Branin function: Commonly used for testing optimization algorithms. \code{\link{F17}}
  \item \bold{F18} - Goldstein-Price function: Four local minima. \code{\link{F18}}
  \item \bold{F19} - Hartman 3D function: 3 dimensions with multiple local minima. \code{\link{F19}}
  \item \bold{F20} - Hartman 6D function: 6 dimensions with multiple local minima. \code{\link{F20}}
  \item \bold{F21} - Shekel 5 function: Based on Shekel's family with 5 terms. \code{\link{F21}}
  \item \bold{F22} - Shekel 7 function: Based on Shekel's family with 7 terms. \code{\link{F22}}
  \item \bold{F23} - Shekel 10 function: Based on Shekel's family with 10 terms. \code{\link{F23}}
}
}
\examples{
# Get details for a specific function
details <- get_function_details("F01")

# Use a test function directly
F01(c(0, 0, 0))  # Returns 0 (global minimum)

# List all available test functions
available_functions <- c("F01", "F02", "F03", "F04", "F05", "F06", "F07", "F08", "F09", "F10",
                       "F11", "F12", "F13", "F14", "F15", "F16", "F17", "F18", "F19", "F20",
                       "F21", "F22", "F23")

}
\references{
Faramarzi, A., Heidarinejad, M., Mirjalili, S., & Gandomi, A. H. (2020).
Marine Predators Algorithm: A Nature-inspired Metaheuristic.
Expert Systems with Applications, 113377.
DOI: 10.1016/j.eswa.2020.113377
}
\seealso{
\code{\link{F01}} through \code{\link{F23}} for individual function documentation.
\code{\link{get_function_details}} to retrieve function details programmatically.
}
\keyword{benchmark}
\keyword{optimization}
\keyword{testing}
