% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_png.R
\name{mf_png}
\alias{mf_png}
\title{Export a map in PNG format}
\usage{
mf_png(
  x,
  filename = "map.png",
  width,
  height,
  expandBB = rep(0, 4),
  res = 96,
  ...
)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{SpatRaster}}

\item{filename}{path to the exported file}

\item{width}{width of the figure (pixels)}

\item{height}{height of the figure (pixels)}

\item{expandBB}{fractional values to expand the bounding box with, in each
direction (bottom, left, top, right)}

\item{res}{nominal resolution in ppi}

\item{...}{further parameters}
}
\value{
No return value, a PNG device is initiated.
}
\description{
Export a map with the extent of a spatial object in PNG format.

PNG is a raster graphics file format and PNG export should be used for
maps that do not require further modification.

If \code{width} is specified, then \code{height} is deduced from the width/height
ratio of \code{x}. Alternatively, if \code{height} is specified, then \code{width}
is deduced from the width/height ratio of \code{x}.
This helps to produce maps without too much wasted space.

Use \code{dev.off} to finish the export (see Examples).
}
\examples{
mtq <- mf_get_mtq()
(filename <- tempfile(fileext = ".png"))
mf_png(mtq, filename = filename)
mf_map(mtq)
mf_title()
dev.off()
}
