% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsirmgrm2pl_fixed_gamma.R
\name{lsirmgrm2pl_fixed_gamma}
\alias{lsirmgrm2pl_fixed_gamma}
\title{2PL GRM LSIRM fixing gamma to 1.}
\usage{
lsirmgrm2pl_fixed_gamma(
  data,
  ncat = NULL,
  missing_data = NA,
  missing.val = 99,
  chains = 1,
  multicore = 1,
  seed = NA,
  ndim = 2,
  niter = 15000,
  nburn = 2500,
  nthin = 5,
  nprint = 500,
  jump_beta = 0.4,
  jump_theta = 1,
  jump_alpha = 1,
  jump_z = 0.5,
  jump_w = 0.5,
  pr_mean_beta = 0,
  pr_sd_beta = 1,
  pr_mean_theta = 0,
  pr_sd_theta = 1,
  pr_mean_alpha = 0.5,
  pr_sd_alpha = 1,
  pr_a_theta = 0.001,
  pr_b_theta = 0.001,
  adapt = NULL,
  verbose = FALSE,
  fix_theta_sd = FALSE,
  fix_alpha_1 = TRUE
)
}
\arguments{
\item{data}{Matrix; an ordinal (ordered categorical) item response matrix. Each row represents a respondent, and
each column represents an item. Values can be either \code{0:(K-1)} or \code{1:K}. Missing values can be \code{NA}.}

\item{ncat}{Integer; number of categories \eqn{K}. If \code{NULL}, it is inferred from the observed data.}

\item{missing_data}{Character; the type of missing data assumed. Options are \code{NA}, \code{"mar"}, or
\code{"mcar"}. If \code{NA} and \code{data} contains missing values, it is set to \code{"mcar"} internally.}

\item{missing.val}{Numeric; numeric code used to represent missing values in the C++ sampler. Default is 99.}

\item{chains}{Integer; number of MCMC chains. Default is 1.}

\item{multicore}{Integer; number of cores for parallel execution when \code{chains > 1}. Default is 1.}

\item{seed}{Integer; RNG seed. Default is \code{NA}.}

\item{ndim}{Integer; latent space dimension. Default is 2.}

\item{niter}{Integer; total MCMC iterations. Default is 15000.}

\item{nburn}{Integer; burn-in iterations. Default is 2500.}

\item{nthin}{Integer; thinning interval. Default is 5.}

\item{nprint}{Integer; print interval if \code{verbose=TRUE}. Default is 500.}

\item{jump_beta}{Numeric; proposal SD for GRM thresholds. Default is 0.4. During MCMC sampling, threshold proposals are constrained to maintain the ordering \eqn{\beta_{i,1} > \beta_{i,2} > \cdots > \beta_{i,K-1}} for each item.}

\item{jump_theta}{Numeric; proposal SD for theta. Default is 1.}

\item{jump_alpha}{Numeric; proposal SD on log-scale for \eqn{\alpha}. Default is 1.}

\item{jump_z}{Numeric; proposal SD for z. Default is 0.5.}

\item{jump_w}{Numeric; proposal SD for w. Default is 0.5.}

\item{pr_mean_beta}{Numeric; prior mean for thresholds. Default is 0.}

\item{pr_sd_beta}{Numeric; prior SD for thresholds. Default is 1.}

\item{pr_mean_theta}{Numeric; prior mean for theta. Default is 0.}

\item{pr_sd_theta}{Numeric; prior SD for theta. Default is 1.}

\item{pr_mean_alpha}{Numeric; log-normal prior mean for \eqn{\alpha}. Default is 0.5.}

\item{pr_sd_alpha}{Numeric; log-normal prior SD for \eqn{\alpha}. Default is 1.}

\item{pr_a_theta}{Numeric; shape for inverse-gamma prior on var(theta). Default is 0.001.}

\item{pr_b_theta}{Numeric; scale for inverse-gamma prior on var(theta). Default is 0.001.}

\item{adapt}{List; optional adaptive MCMC control. If not \code{NULL}, proposal standard deviations are adapted during the burn-in period to reach a target acceptance rate and are held fixed during the main MCMC sampling.
When adaptation is enabled, the reported acceptance ratios in the output (\code{accept_beta}, \code{accept_theta}, \code{accept_alpha}, etc.) are computed only from iterations after burn-in, reflecting the performance of the adapted proposal distributions.
Elements of the list can include:
\itemize{
  \item \code{use_adapt}: Logical; if \code{TRUE}, adaptive MCMC is used. Default is \code{FALSE}.
  \item \code{adapt_interval}: Integer; the number of iterations between each update of the proposal SDs. Default is \code{100}.
  \item \code{adapt_rate}: Numeric; Robbins-Monro scaling constant (c) in step size formula: adapt_rate / iteration^decay_rate. Default is \code{1.0}. Valid range: any positive value. Recommended: 0.5-2.0.
  \item \code{decay_rate}: Numeric; Robbins-Monro decay exponent (alpha) in step size formula. Default is \code{0.5}. Valid range: (0.5, 1]. Recommended: 0.5-0.8.
  \item \code{target_accept}: Numeric; target acceptance rate for scalar parameters (beta, theta, gamma, alpha). Default is \code{0.44}.
  \item \code{target_accept_zw}: Numeric; target acceptance rate for multi-dimensional latent positions z and w. Default is \code{0.234}.
  \item \code{target_accept_beta/theta/alpha/gamma}: Numeric; (optional) parameter-specific target acceptance rates to override \code{target_accept}.
}}

\item{verbose}{Logical; If TRUE, MCMC samples are printed for each \code{nprint}. default value is FALSE}

\item{fix_theta_sd}{Logical; If TRUE, the standard deviation of the respondent latent positions \eqn{\theta} is fixed at 1 instead of being sampled. Default is FALSE.}

\item{fix_alpha_1}{Logical; if TRUE, fixes \eqn{\alpha_1 = 1}. Default is TRUE.}
}
\value{
\code{lsirmgrm2pl_fixed_gamma} returns an object of  list containing the same components as \code{\link{lsirmgrm2pl}}.
}
\description{
\link{lsirmgrm2pl_fixed_gamma} is used to fit 2PL GRM LSIRM with gamma fixed to 1.
}
\examples{
\donttest{
# generate example ordinal item response matrix
set.seed(123)
nsample <- 50
nitem <- 10
data <- matrix(sample(1:5, nsample * nitem, replace = TRUE), nrow = nsample)

# Fit 2PL GRM LSIRM with fixed gamma = 1
fit <- lsirmgrm2pl_fixed_gamma(data, niter = 1000, nburn = 500)
summary(fit)
}

}
